/*
 * Decompiled with CFR 0.152.
 */
package io.seata.discovery.loadbalance;

import io.seata.common.loader.LoadLevel;
import io.seata.common.rpc.RpcStatus;
import io.seata.discovery.loadbalance.AbstractLoadBalance;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

@LoadLevel(name="LeastActiveLoadBalance")
public class LeastActiveLoadBalance
extends AbstractLoadBalance {
    @Override
    protected <T> T doSelect(List<T> invokers, String xid) {
        int length = invokers.size();
        long leastActive = -1L;
        int leastCount = 0;
        int[] leastIndexes = new int[length];
        for (int i = 0; i < length; ++i) {
            long active = RpcStatus.getStatus((String)invokers.get(i).toString()).getActive();
            if (leastActive == -1L || active < leastActive) {
                leastActive = active;
                leastCount = 1;
                leastIndexes[0] = i;
                continue;
            }
            if (active != leastActive) continue;
            leastIndexes[leastCount++] = i;
        }
        if (leastCount == 1) {
            return invokers.get(leastIndexes[0]);
        }
        return invokers.get(leastIndexes[ThreadLocalRandom.current().nextInt(leastCount)]);
    }
}

