/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.contrib.dropwizard;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import io.opencensus.common.Clock;
import io.opencensus.common.Timestamp;
import io.opencensus.contrib.dropwizard.DropWizardUtils;
import io.opencensus.implcore.common.MillisClock;
import io.opencensus.internal.Utils;
import io.opencensus.metrics.export.Metric;
import io.opencensus.metrics.export.MetricDescriptor;
import io.opencensus.metrics.export.MetricProducer;
import io.opencensus.metrics.export.Point;
import io.opencensus.metrics.export.Summary;
import io.opencensus.metrics.export.TimeSeries;
import io.opencensus.metrics.export.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class DropWizardMetrics
extends MetricProducer {
    static final String DEFAULT_UNIT = "1";
    static final String NS_UNIT = "ns";
    private final List<MetricRegistry> metricRegistryList;
    private final MetricFilter metricFilter;
    private final Clock clock;
    private final Timestamp cumulativeStartTimestamp;

    public DropWizardMetrics(List<MetricRegistry> metricRegistryList) {
        this(metricRegistryList, MetricFilter.ALL);
    }

    public DropWizardMetrics(List<MetricRegistry> metricRegistryList, MetricFilter metricFilter) {
        Utils.checkListElementNotNull((List)((List)Utils.checkNotNull(metricRegistryList, (Object)"metricRegistryList")), (Object)"metricRegistry");
        this.metricRegistryList = metricRegistryList;
        this.metricFilter = (MetricFilter)Utils.checkNotNull((Object)metricFilter, (Object)"metricFilter");
        this.clock = MillisClock.getInstance();
        this.cumulativeStartTimestamp = this.clock.now();
    }

    @Nullable
    private Metric collectGauge(String dropwizardName, Gauge gauge) {
        Value value;
        MetricDescriptor.Type type;
        String metricName = DropWizardUtils.generateFullMetricName(dropwizardName, "gauge");
        String metricDescription = DropWizardUtils.generateFullMetricDescription(dropwizardName, (com.codahale.metrics.Metric)gauge);
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            type = MetricDescriptor.Type.GAUGE_DOUBLE;
            value = Value.doubleValue((double)((Number)obj).doubleValue());
        } else if (obj instanceof Boolean) {
            type = MetricDescriptor.Type.GAUGE_INT64;
            value = Value.longValue((long)((Boolean)obj != false ? 1L : 0L));
        } else {
            return null;
        }
        MetricDescriptor metricDescriptor = MetricDescriptor.create((String)metricName, (String)metricDescription, (String)DEFAULT_UNIT, (MetricDescriptor.Type)type, Collections.emptyList());
        TimeSeries timeSeries = TimeSeries.createWithOnePoint(Collections.emptyList(), (Point)Point.create((Value)value, (Timestamp)this.clock.now()), null);
        return Metric.createWithOneTimeSeries((MetricDescriptor)metricDescriptor, (TimeSeries)timeSeries);
    }

    private Metric collectCounter(String dropwizardName, Counter counter) {
        String metricName = DropWizardUtils.generateFullMetricName(dropwizardName, "counter");
        String metricDescription = DropWizardUtils.generateFullMetricDescription(dropwizardName, (com.codahale.metrics.Metric)counter);
        MetricDescriptor metricDescriptor = MetricDescriptor.create((String)metricName, (String)metricDescription, (String)DEFAULT_UNIT, (MetricDescriptor.Type)MetricDescriptor.Type.GAUGE_INT64, Collections.emptyList());
        TimeSeries timeSeries = TimeSeries.createWithOnePoint(Collections.emptyList(), (Point)Point.create((Value)Value.longValue((long)counter.getCount()), (Timestamp)this.clock.now()), null);
        return Metric.createWithOneTimeSeries((MetricDescriptor)metricDescriptor, (TimeSeries)timeSeries);
    }

    private Metric collectMeter(String dropwizardName, Meter meter) {
        String metricName = DropWizardUtils.generateFullMetricName(dropwizardName, "meter");
        String metricDescription = DropWizardUtils.generateFullMetricDescription(dropwizardName, (com.codahale.metrics.Metric)meter);
        MetricDescriptor metricDescriptor = MetricDescriptor.create((String)metricName, (String)metricDescription, (String)DEFAULT_UNIT, (MetricDescriptor.Type)MetricDescriptor.Type.CUMULATIVE_INT64, Collections.emptyList());
        TimeSeries timeSeries = TimeSeries.createWithOnePoint(Collections.emptyList(), (Point)Point.create((Value)Value.longValue((long)meter.getCount()), (Timestamp)this.clock.now()), (Timestamp)this.cumulativeStartTimestamp);
        return Metric.createWithOneTimeSeries((MetricDescriptor)metricDescriptor, (TimeSeries)timeSeries);
    }

    private Metric collectHistogram(String dropwizardName, Histogram histogram) {
        String metricName = DropWizardUtils.generateFullMetricName(dropwizardName, "histogram");
        String metricDescription = DropWizardUtils.generateFullMetricDescription(dropwizardName, (com.codahale.metrics.Metric)histogram);
        return this.collectSnapshotAndCount(metricName, metricDescription, DEFAULT_UNIT, histogram.getSnapshot(), histogram.getCount());
    }

    private Metric collectTimer(String dropwizardName, Timer timer) {
        String metricName = DropWizardUtils.generateFullMetricName(dropwizardName, "timer");
        String metricDescription = DropWizardUtils.generateFullMetricDescription(dropwizardName, (com.codahale.metrics.Metric)timer);
        return this.collectSnapshotAndCount(metricName, metricDescription, NS_UNIT, timer.getSnapshot(), timer.getCount());
    }

    private Metric collectSnapshotAndCount(String metricName, String metricDescription, String unit, Snapshot codahaleSnapshot, long count) {
        List<Summary.Snapshot.ValueAtPercentile> valueAtPercentiles = Arrays.asList(Summary.Snapshot.ValueAtPercentile.create((double)50.0, (double)codahaleSnapshot.getMedian()), Summary.Snapshot.ValueAtPercentile.create((double)75.0, (double)codahaleSnapshot.get75thPercentile()), Summary.Snapshot.ValueAtPercentile.create((double)98.0, (double)codahaleSnapshot.get98thPercentile()), Summary.Snapshot.ValueAtPercentile.create((double)99.0, (double)codahaleSnapshot.get99thPercentile()), Summary.Snapshot.ValueAtPercentile.create((double)99.9, (double)codahaleSnapshot.get999thPercentile()));
        Summary.Snapshot snapshot = Summary.Snapshot.create((Long)Long.valueOf(codahaleSnapshot.size()), (Double)0.0, valueAtPercentiles);
        Point point = Point.create((Value)Value.summaryValue((Summary)Summary.create((Long)count, (Double)0.0, (Summary.Snapshot)snapshot)), (Timestamp)this.clock.now());
        MetricDescriptor metricDescriptor = MetricDescriptor.create((String)metricName, (String)metricDescription, (String)unit, (MetricDescriptor.Type)MetricDescriptor.Type.SUMMARY, Collections.emptyList());
        TimeSeries timeSeries = TimeSeries.createWithOnePoint(Collections.emptyList(), (Point)point, (Timestamp)this.cumulativeStartTimestamp);
        return Metric.createWithOneTimeSeries((MetricDescriptor)metricDescriptor, (TimeSeries)timeSeries);
    }

    public Collection<Metric> getMetrics() {
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        for (MetricRegistry metricRegistry : this.metricRegistryList) {
            for (Map.Entry counterEntry : metricRegistry.getCounters(this.metricFilter).entrySet()) {
                metrics.add(this.collectCounter((String)counterEntry.getKey(), (Counter)counterEntry.getValue()));
            }
            for (Map.Entry gaugeEntry : metricRegistry.getGauges(this.metricFilter).entrySet()) {
                Metric metric = this.collectGauge((String)gaugeEntry.getKey(), (Gauge)gaugeEntry.getValue());
                if (metric == null) continue;
                metrics.add(metric);
            }
            for (Map.Entry counterEntry : metricRegistry.getMeters(this.metricFilter).entrySet()) {
                metrics.add(this.collectMeter((String)counterEntry.getKey(), (Meter)counterEntry.getValue()));
            }
            for (Map.Entry counterEntry : metricRegistry.getHistograms(this.metricFilter).entrySet()) {
                metrics.add(this.collectHistogram((String)counterEntry.getKey(), (Histogram)counterEntry.getValue()));
            }
            for (Map.Entry counterEntry : metricRegistry.getTimers(this.metricFilter).entrySet()) {
                metrics.add(this.collectTimer((String)counterEntry.getKey(), (Timer)counterEntry.getValue()));
            }
        }
        return metrics;
    }
}

