/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.xxl;

import com.xxl.job.core.executor.XxlJobExecutor;
import com.xxl.job.core.glue.GlueFactory;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import io.github.logtube.xxl.LogtubeWrapperJobHandler;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LogtubeXxlJobSpringExecutor
extends XxlJobExecutor
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;

    public void start() throws Exception {
        this.initJobHandlerRepository(applicationContext);
        GlueFactory.refreshInstance((int)1);
        super.start();
    }

    private void initJobHandlerRepository(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            return;
        }
        Map serviceBeanMap = applicationContext.getBeansWithAnnotation(JobHandler.class);
        if (serviceBeanMap != null && serviceBeanMap.size() > 0) {
            for (Object serviceBean : serviceBeanMap.values()) {
                if (!(serviceBean instanceof IJobHandler)) continue;
                String name = serviceBean.getClass().getAnnotation(JobHandler.class).value();
                IJobHandler handler = (IJobHandler)serviceBean;
                if (LogtubeXxlJobSpringExecutor.loadJobHandler((String)name) != null) {
                    throw new RuntimeException("xxl-job jobhandler naming conflicts.");
                }
                LogtubeXxlJobSpringExecutor.registJobHandler((String)name, (IJobHandler)new LogtubeWrapperJobHandler(name, handler));
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        LogtubeXxlJobSpringExecutor.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }
}

