/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.utils;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Strings {
    private static final Pattern PATTERN_ENVIRONMENT_VARIABLE = Pattern.compile("\\$\\{([A-Za-z0-9_-]+)\\}");

    @Contract(value="_, !null -> !null")
    @Nullable
    public static String sanitize(@Nullable String str, @Nullable String defaultValue) {
        if ((str = Strings.normalize(str)) == null || str.length() == 0) {
            return defaultValue;
        }
        return str.toLowerCase().replaceAll("[^0-9a-zA-Z_-]", "_");
    }

    public static boolean isEmpty(@Nullable String s) {
        if (s == null) {
            return true;
        }
        if (s.length() == 0) {
            return true;
        }
        return s.trim().length() == 0;
    }

    @Nullable
    public static String normalize(@Nullable String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        return s;
    }

    @NotNull
    public static String safeNormalize(@Nullable String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    @NotNull
    public static String safeNormalize(@Nullable Object o) {
        if (o == null) {
            return "null";
        }
        return Strings.safeNormalize(o.toString());
    }

    @NotNull
    public static String safeNormalizeKeyword(@Nullable String s) {
        if ((s = Strings.normalize(s)) == null) {
            return "null";
        }
        return s.replaceAll("[\\s,\\[\\]]+", "_");
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String evaluateEnvironmentVariables(@Nullable String s) {
        Matcher m;
        if (s == null) {
            return null;
        }
        while ((m = PATTERN_ENVIRONMENT_VARIABLE.matcher(s)).find()) {
            String value = System.getenv(m.group(1));
            if (value == null) {
                value = "";
            }
            String s1 = s.substring(0, m.start());
            String s2 = s.substring(m.end());
            s = s1 + value + s2;
        }
        return s;
    }

    @NotNull
    public static String keyword(Object ... os) {
        if (os == null || os.length == 0 || os.length > 100) {
            return "";
        }
        return " K[" + Arrays.stream(os).map(String::valueOf).map(Strings::safeNormalizeKeyword).collect(Collectors.joining(",")) + "]";
    }
}

