/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.utils;

import io.github.logtube.utils.Bytes;
import io.github.logtube.utils.InetEndpoint;
import io.github.logtube.utils.IntervalChecker;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SPTPClient {
    private static final int DEFAULT_PORT = 9921;
    private static final byte MAGIC = -6;
    private static final byte MODE_SIMPLE = 0;
    private static final byte MODE_CHUNKED = 1;
    private static final int PACKET_MAX_SIZE = 8192;
    private static final int PACKET_PAYLOAD_MAX_SIZE = 8180;
    private static final int CHUNKED_MAX_COUNT = 255;
    private static final int PAYLOAD_MAX_SIZE = 2085900;
    private final byte[] buffer = new byte[8192];
    private final IntervalChecker resolveChecker = new IntervalChecker(30000L);
    @NotNull
    private final String[] hosts;
    private final InetEndpoint[] endpoints;
    private final AtomicInteger count = new AtomicInteger();
    private DatagramSocket socket = null;

    public SPTPClient(String[] hosts) {
        this.hosts = hosts;
        this.endpoints = new InetEndpoint[hosts.length];
        this.buffer[0] = -6;
        this.resolveHosts();
    }

    private void resolveHosts() {
        for (int i = 0; i < this.hosts.length; ++i) {
            this.endpoints[i] = InetEndpoint.fromString(this.hosts[i], 9921);
        }
    }

    public void send(byte[] payload) throws IOException {
        int total;
        if (2085900 < payload.length) {
            return;
        }
        if (this.resolveChecker.check()) {
            this.resolveHosts();
        }
        int hostIdx = this.count.incrementAndGet() % this.hosts.length;
        if (payload.length < 8180) {
            this.buffer[1] = 0;
            System.arraycopy(payload, 0, this.buffer, 2, payload.length);
            this.sendPacket(hostIdx, payload.length + 2);
        }
        if ((total = payload.length / 8180) % 8180 != 0) {
            ++total;
        }
        this.buffer[1] = 1;
        Bytes.randomBytes(this.buffer, 2, 8);
        this.buffer[10] = (byte)total;
        for (int i = 0; i < total; ++i) {
            this.buffer[11] = (byte)i;
            int offsetFrom = i * 8180;
            int offsetTo = (i + 1) * 8180;
            if (offsetTo > payload.length) {
                offsetTo = payload.length;
            }
            System.arraycopy(payload, offsetFrom, this.buffer, 12, offsetTo - offsetFrom);
            this.sendPacket(hostIdx, 12 + offsetTo - offsetFrom);
        }
    }

    private void sendPacket(int hostIndex, int length) throws IOException {
        InetEndpoint endpoint;
        if (this.socket == null) {
            this.socket = new DatagramSocket();
        }
        if ((endpoint = this.endpoints[hostIndex]) == null) {
            return;
        }
        this.socket.send(new DatagramPacket(this.buffer, 0, length, endpoint.getAddress(), endpoint.getPort()));
    }
}

