/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.utils;

import io.github.logtube.utils.Dates;
import io.github.logtube.utils.RotationFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class RotationThread
extends Thread {
    private Mode mode = Mode.None;
    private long size = 0x10000000L;
    private int keep = 0;
    @NotNull
    private String project = "";
    @NotNull
    private Set<String> dirs = new HashSet<String>();
    @NotNull
    private Set<String> signalFiles = new HashSet<String>();

    public static void collectFiles(Set<String> result, File file) {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                RotationThread.collectFiles(result, f);
            }
        } else {
            String abs = file.getAbsolutePath();
            if (abs.toLowerCase().endsWith(".log")) {
                result.add(abs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(@NotNull String mode, int keep, @NotNull Set<String> dirs, @NotNull Set<String> signalFiles, @NotNull String project) {
        RotationThread rotationThread = this;
        synchronized (rotationThread) {
            if (mode.equalsIgnoreCase("daily")) {
                this.mode = Mode.Daily;
                this.size = 0L;
            } else if (mode.toLowerCase().endsWith("mb")) {
                this.mode = Mode.Size;
                this.size = Long.parseLong(mode.substring(0, mode.length() - 2)) * 1024L * 1024L;
            } else {
                this.mode = Mode.None;
                this.size = 0L;
            }
            this.project = project;
            this.keep = keep;
            this.dirs = dirs;
            this.signalFiles = signalFiles;
        }
    }

    private boolean rotateDirs() {
        AtomicBoolean rotated = new AtomicBoolean(false);
        HashSet<String> files = new HashSet<String>();
        this.dirs.forEach(d -> RotationThread.collectFiles(files, new File((String)d)));
        HashMap<String, RotationFile> rotationFiles = RotationFile.fromFiles(files, this.project);
        rotationFiles.forEach((filename, rf) -> {
            Set<String> marks = rf.getMarks();
            Set<String> badMarks = marks.stream().filter(m -> {
                if (this.mode == Mode.Daily) {
                    return !m.matches("^\\d{4}-\\d{2}-\\d{2}$");
                }
                if (this.mode == Mode.Size) {
                    return !m.matches("^\\d+$");
                }
                return false;
            }).collect(Collectors.toSet());
            badMarks.forEach(m -> {
                marks.remove(m);
                new File(RotationFile.deriveFilename(filename, m)).delete();
            });
            ArrayList<String> markList = new ArrayList<String>(marks);
            markList.sort(Comparator.comparing(String::toString));
            if (this.keep > 0 && marks.size() > this.keep) {
                List<String> deleteList = markList.subList(0, marks.size() - this.keep + 1);
                deleteList.forEach(m -> new File(RotationFile.deriveFilename(filename, m)).delete());
            }
            if (this.mode == Mode.Daily) {
                String newMark = Dates.formatDateMark(System.currentTimeMillis() - 86400000L);
                if (marks.contains(newMark)) {
                    return;
                }
                String newFilename = RotationFile.deriveFilename(filename, newMark);
                new File((String)filename).renameTo(new File(newFilename));
                rotated.set(true);
            } else if (this.mode == Mode.Size) {
                if (new File((String)filename).length() < this.size) {
                    return;
                }
                long nextId = 1L;
                if (!markList.isEmpty()) {
                    try {
                        nextId = Long.parseLong(markList.get(markList.size() - 1)) + 1L;
                    }
                    catch (NumberFormatException ignored) {
                        return;
                    }
                }
                String newFilename = RotationFile.deriveFilename(filename, String.format("%012d", nextId));
                new File((String)filename).renameTo(new File(newFilename));
                rotated.set(true);
            }
            if (!new File((String)filename).exists()) {
                rotated.set(true);
            }
        });
        return rotated.get();
    }

    private void touchSignals() {
        this.signalFiles.forEach(f -> {
            try {
                FileWriter fw = new FileWriter((String)f);
                fw.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            new File((String)f).setLastModified(System.currentTimeMillis());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException ignored) {
                return;
            }
            RotationThread rotationThread = this;
            synchronized (rotationThread) {
                if (this.mode == Mode.None) {
                    continue;
                }
                try {
                    if (this.rotateDirs()) {
                        this.touchSignals();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static enum Mode {
        None,
        Daily,
        Size;

    }
}

