/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.utils;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Reflections {
    private static final String LOGTUBE_BOUNDARY_PREFIX = "io.github.logtube.";

    private static boolean isInternalClass(@NotNull String className) {
        return className.startsWith(LOGTUBE_BOUNDARY_PREFIX) && !className.contains("Test");
    }

    @Nullable
    public static StackTraceElement getStackTraceElement() {
        StackTraceElement[] stackTraceElements;
        boolean found = false;
        for (StackTraceElement element : stackTraceElements = Thread.currentThread().getStackTrace()) {
            if (Reflections.isInternalClass(element.getClassName())) {
                found = true;
                continue;
            }
            if (!found) continue;
            return element;
        }
        return null;
    }

    @Nullable
    public static StackTraceElement[] getStackTraceElements() {
        StackTraceElement[] stackTraceElements;
        ArrayList<StackTraceElement> result = new ArrayList<StackTraceElement>();
        boolean found = false;
        for (StackTraceElement element : stackTraceElements = Thread.currentThread().getStackTrace()) {
            if (Reflections.isInternalClass(element.getClassName())) {
                found = true;
                continue;
            }
            if (!found) continue;
            result.add(element);
        }
        return result.toArray(new StackTraceElement[0]);
    }
}

