/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InetEndpoint {
    @NotNull
    private final InetAddress address;
    private final int port;

    public InetEndpoint(@NotNull InetAddress address, int port) {
        this.address = address;
        this.port = port;
    }

    @NotNull
    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public static InetEndpoint fromString(@NotNull String str, int defaultPort) {
        String host = null;
        int port = 0;
        if (str.contains(":")) {
            String[] compos = str.split(":");
            host = compos[0];
            try {
                port = Integer.valueOf(compos[1]);
            }
            catch (NumberFormatException ignored) {
                port = defaultPort;
            }
        } else {
            host = str;
            port = defaultPort;
        }
        try {
            InetAddress address = InetAddress.getByName(host);
            return new InetEndpoint(address, port);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

