/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.utils;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Hex {
    private static final Random RANDOM = new Random(new SecureRandom().nextLong());
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    @NotNull
    public static String randomHex16() {
        return Hex.toHex(RANDOM.nextLong());
    }

    @NotNull
    public static String toHex(long value) {
        char[] chars = new char[16];
        for (int i = 0; i < 16; ++i) {
            int c = (int)(value & 0xFL);
            chars[16 - i - 1] = HEX_CHARS[c];
            value >>= 4;
        }
        return new String(chars);
    }

    @NotNull
    public static String toHex(byte b) {
        return new String(new char[]{HEX_CHARS[(b & 0xF0) >> 4], HEX_CHARS[b & 0xF]});
    }

    @Nullable
    public static String md5(@Nullable String str) {
        if (str == null) {
            return null;
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] result = md5.digest(str.getBytes(StandardCharsets.UTF_8));
            StringBuilder buffer = new StringBuilder();
            for (byte b : result) {
                buffer.append(HEX_CHARS[(b & 0xF0) >> 4]);
                buffer.append(HEX_CHARS[b & 0xF]);
            }
            return buffer.toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

