/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Flatten {
    private static final Gson gson = new GsonBuilder().create();

    @Nullable
    public static ArrayList<String> flattenJSON(@Nullable String json) {
        if (json == null) {
            return null;
        }
        ArrayList<String> out = new ArrayList<String>();
        try {
            Map map = (Map)gson.fromJson(json, Map.class);
            if (map == null) {
                return null;
            }
            Flatten.mergeMap(map, "", out);
        }
        catch (Exception e) {
            return null;
        }
        return out;
    }

    @Nullable
    public static ArrayList<String> flattenParameters(@Nullable Map<String, String[]> parameters) {
        if (parameters == null) {
            return null;
        }
        ArrayList<String> out = new ArrayList<String>();
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            if (entry.getValue() == null || entry.getValue().length == 0) continue;
            if (entry.getValue().length == 1) {
                out.add(entry.getKey() + "=" + entry.getValue()[0]);
                continue;
            }
            Flatten.mergeList(Arrays.asList((Object[])entry.getValue()), entry.getKey() + ".", out);
        }
        return out;
    }

    @NotNull
    public static byte[] objectToByteArray(@NotNull Object o) {
        return gson.toJson(o).getBytes();
    }

    private static void mergeMap(Map input, String prefix, ArrayList<String> output) {
        if (prefix == null) {
            prefix = "";
        }
        Set entries = input.entrySet();
        for (Map.Entry entry : entries) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            if (entry.getValue() instanceof Map) {
                Flatten.mergeMap((Map)entry.getValue(), prefix + entry.getKey().toString() + ".", output);
                continue;
            }
            if (entry.getValue() instanceof List) {
                Flatten.mergeList((List)entry.getValue(), prefix + entry.getKey().toString() + ".", output);
                continue;
            }
            output.add(prefix + entry.getKey().toString() + "=" + entry.getValue().toString());
        }
    }

    private static void mergeList(List input, String prefix, ArrayList<String> output) {
        if (prefix == null) {
            prefix = "";
        }
        int index = -1;
        for (Object value : input) {
            ++index;
            if (value == null) continue;
            if (value instanceof Map) {
                Flatten.mergeMap((Map)value, prefix + index + ".", output);
                continue;
            }
            if (value instanceof List) {
                Flatten.mergeList((List)value, prefix + index + ".", output);
                continue;
            }
            output.add(prefix + index + "=" + value.toString());
        }
    }
}

