/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class Dates {
    private static final ThreadLocal<SimpleDateFormat> LINE_TIMESTAMP_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat get() {
            return new SimpleDateFormat("[yyyy-MM-dd HH:mm:ss.SSS ZZZZZ]");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> DATE_MARK_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        public SimpleDateFormat get() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };

    @NotNull
    public static String formatLineTimestamp(long epoch) {
        return LINE_TIMESTAMP_FORMAT.get().format(new Date(epoch));
    }

    @NotNull
    public static String formatDateMark(long epoch) {
        return DATE_MARK_FORMAT.get().format(new Date(epoch));
    }
}

