/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.thread;

import io.github.logtube.Logtube;
import io.github.logtube.core.IEventContext;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class LogtubeThreadPoolExecutor
extends ThreadPoolExecutor {
    private final ConcurrentHashMap<Runnable, IEventContext> eventContexts = new ConcurrentHashMap();

    public LogtubeThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public LogtubeThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    public LogtubeThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    public LogtubeThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        IEventContext context = this.eventContexts.get(r);
        if (context != null) {
            context.restore();
        }
    }

    @Override
    public void execute(Runnable command) {
        this.eventContexts.put(command, Logtube.captureContext());
        super.execute(command);
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        Logtube.getProcessor().clearContext();
        this.eventContexts.remove(r);
        super.afterExecute(r, t);
    }
}

