/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.rocketmq;

import io.github.logtube.Logtube;
import org.apache.rocketmq.common.message.MessageExt;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.integration.channel.ChannelInterceptorAware;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ChannelInterceptorAdapter;
import org.springframework.messaging.support.MessageBuilder;

@Configuration
public class RocketMqConfig {
    private static final String ROCKETMQ_MESSAGE_OBJECT_KEY = "ORIGINAL_ROCKETMQ_MESSAGE";
    private static final String BEAN_NAME_INPUT = "input";
    private static final String BEAN_NAME_OUTPUT = "output";

    @Bean
    public BeanPostProcessor channelConfigurer() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (RocketMqConfig.BEAN_NAME_INPUT.equals(beanName) && bean instanceof ChannelInterceptorAware) {
                    ((ChannelInterceptorAware)bean).addInterceptor((ChannelInterceptor)new ChannelInterceptorAdapter(){

                        public Message<?> preSend(Message<?> message, MessageChannel channel) {
                            message.getHeaders().entrySet().forEach(h -> {
                                if (RocketMqConfig.ROCKETMQ_MESSAGE_OBJECT_KEY.equals(h.getKey())) {
                                    MessageExt me = (MessageExt)h.getValue();
                                    Logtube.getProcessor().setCrid(me.getProperty("crid"));
                                    Logtube.getProcessor().setCrsrc(me.getProperty("crsrc"));
                                }
                            });
                            return message;
                        }
                    });
                } else if (RocketMqConfig.BEAN_NAME_OUTPUT.equals(beanName) && bean instanceof ChannelInterceptorAware) {
                    ((ChannelInterceptorAware)bean).addInterceptor((ChannelInterceptor)new ChannelInterceptorAdapter(){

                        public Message<?> preSend(Message<?> message, MessageChannel channel) {
                            MessageBuilder messageBuilder = MessageBuilder.fromMessage(message);
                            messageBuilder.setHeader("crid", (Object)Logtube.getProcessor().getCrid());
                            messageBuilder.setHeader("crsrc", (Object)Logtube.getProcessor().getProject());
                            return messageBuilder.build();
                        }
                    });
                }
                return bean;
            }
        };
    }
}

