/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.redis;

import io.github.logtube.Logtube;
import io.github.logtube.core.IMutableEvent;
import io.github.logtube.utils.Flatten;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.Protocol;

public class RedisTrackEventCommitter {
    private static int minDuration = 0;
    private static int minResultSize = 0;
    private final IMutableEvent event = Logtube.getLogger(RedisTrackEventCommitter.class).topic("x-redis-track");
    private final long startTime = System.currentTimeMillis();

    public static void setMinDuration(int minDuration) {
        RedisTrackEventCommitter.minDuration = minDuration;
    }

    public static void setMinResultSize(int minResultSize) {
        RedisTrackEventCommitter.minResultSize = minResultSize;
    }

    public void commit(Object res) {
        long duration = System.currentTimeMillis() - this.startTime;
        int resultSize = Flatten.objectToByteArray(res).length;
        if (duration >= (long)minDuration || resultSize >= minResultSize) {
            this.event.xDuration(duration).extra("result_size", resultSize).commit();
        }
    }

    public void setCmdAndArgs(@NotNull Protocol.Command cmd, byte[][] args) {
        this.event.extra("cmd", cmd.name());
        long paramValueSize = 0L;
        if (args != null && args.length > 0) {
            this.event.extra("key", new String(args[0]));
            for (int i = 1; i < args.length; ++i) {
                paramValueSize += (long)args[i].length;
            }
            this.event.extra("param_value_size", paramValueSize);
        }
    }
}

