/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.redis;

import io.github.logtube.redis.RedisTrackEventCommitter;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Client;
import redis.clients.jedis.Connection;
import redis.clients.jedis.Protocol;

public class LogtubeRedisClient
extends Client {
    private RedisTrackEventCommitter builder;
    private static final Logger LOGGER = LoggerFactory.getLogger(LogtubeRedisClient.class);
    private static final List<Protocol.Command> LOG_BLACK_LIST = new ArrayList<Protocol.Command>();
    private boolean needSkipLog = true;

    public LogtubeRedisClient() {
    }

    public LogtubeRedisClient(String host) {
        super(host);
    }

    public LogtubeRedisClient(String host, int port) {
        super(host, port);
    }

    public LogtubeRedisClient(String host, int port, boolean ssl) {
        super(host, port, ssl);
    }

    public LogtubeRedisClient(String host, int port, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        super(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
    }

    protected Connection sendCommand(Protocol.Command cmd, byte[] ... args) {
        this.sendCommandBefore(cmd, args);
        return super.sendCommand(cmd, args);
    }

    protected Object readProtocolWithCheckingBroken() {
        Object res = super.readProtocolWithCheckingBroken();
        this.finished(res);
        return res;
    }

    private void sendCommandBefore(Protocol.Command cmd, byte[] ... args) {
        this.needSkipLog = LOG_BLACK_LIST.contains(cmd);
        if (this.needSkipLog) {
            return;
        }
        try {
            this.builder = new RedisTrackEventCommitter();
            this.builder.setCmdAndArgs(cmd, args);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    private void finished(Object res) {
        if (this.needSkipLog) {
            return;
        }
        try {
            this.builder.commit(res);
        }
        catch (Throwable e) {
            LOGGER.error(e.getMessage(), e);
        }
    }

    static {
        LOG_BLACK_LIST.add(Protocol.Command.PING);
        LOG_BLACK_LIST.add(Protocol.Command.DEL);
    }
}

