/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.redis;

import io.github.logtube.redis.LogtubeJedis;
import io.github.logtube.redis.LogtubeJedisClusterInfoCache;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisSlotBasedConnectionHandler;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisNoReachableClusterNodeException;

public class LogtubeJedisSlotBasedConnectionHandler
extends JedisSlotBasedConnectionHandler {
    protected final LogtubeJedisClusterInfoCache jedisClusterInfoCache;

    public LogtubeJedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int timeout) {
        this(nodes, poolConfig, timeout, timeout);
    }

    public LogtubeJedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout) {
        this(nodes, poolConfig, connectionTimeout, soTimeout, null);
    }

    public LogtubeJedisSlotBasedConnectionHandler(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig, int connectionTimeout, int soTimeout, String password) {
        super(nodes, poolConfig, connectionTimeout, soTimeout, password);
        this.cache.reset();
        this.jedisClusterInfoCache = new LogtubeJedisClusterInfoCache(poolConfig, connectionTimeout, soTimeout, password);
        this.initializeSlotsCache(nodes, poolConfig, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSlotsCache(Set<HostAndPort> startNodes, GenericObjectPoolConfig poolConfig, String password) {
        for (HostAndPort hostAndPort : startNodes) {
            LogtubeJedis jedis = new LogtubeJedis(hostAndPort.getHost(), hostAndPort.getPort());
            if (password != null) {
                jedis.auth(password);
            }
            try {
                this.jedisClusterInfoCache.discoverClusterNodesAndSlots(jedis);
                break;
            }
            catch (JedisConnectionException jedisConnectionException) {}
            continue;
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
    }

    public Jedis getConnectionFromNode(HostAndPort node) {
        return this.jedisClusterInfoCache.setupNodeIfNotExist(node).getResource();
    }

    public Map<String, JedisPool> getNodes() {
        return this.jedisClusterInfoCache.getNodes();
    }

    public Jedis getConnection() {
        List<JedisPool> pools = this.jedisClusterInfoCache.getShuffledNodesPool();
        for (JedisPool pool : pools) {
            Jedis jedis = null;
            try {
                jedis = pool.getResource();
                if (jedis == null) continue;
                String result = jedis.ping();
                if (result.equalsIgnoreCase("pong")) {
                    return jedis;
                }
                jedis.close();
            }
            catch (JedisException ex) {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        throw new JedisNoReachableClusterNodeException("No reachable node in cluster");
    }

    public Jedis getConnectionFromSlot(int slot) {
        JedisPool connectionPool = this.jedisClusterInfoCache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        this.renewSlotCache();
        connectionPool = this.jedisClusterInfoCache.getSlotPool(slot);
        if (connectionPool != null) {
            return connectionPool.getResource();
        }
        return this.getConnection();
    }

    public void renewSlotCache() {
        this.jedisClusterInfoCache.renewClusterSlots(null);
    }

    public void renewSlotCache(Jedis jedis) {
        this.jedisClusterInfoCache.renewClusterSlots(jedis);
    }

    public void close() {
        this.jedisClusterInfoCache.reset();
    }
}

