/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.redis;

import io.github.logtube.redis.LogtubeJedisSlotBasedConnectionHandler;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;

public class LogtubeJedisCluster
extends JedisCluster {
    public LogtubeJedisCluster(HostAndPort node) {
        this(Collections.singleton(node), 2000);
    }

    public LogtubeJedisCluster(HostAndPort node, int timeout) {
        this(Collections.singleton(node), timeout, 5);
    }

    public LogtubeJedisCluster(HostAndPort node, int timeout, int maxAttempts) {
        this(Collections.singleton(node), timeout, maxAttempts, new GenericObjectPoolConfig());
    }

    public LogtubeJedisCluster(HostAndPort node, GenericObjectPoolConfig poolConfig) {
        this(Collections.singleton(node), 2000, 5, poolConfig);
    }

    public LogtubeJedisCluster(HostAndPort node, int timeout, GenericObjectPoolConfig poolConfig) {
        this(Collections.singleton(node), timeout, 5, poolConfig);
    }

    public LogtubeJedisCluster(HostAndPort node, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        this(Collections.singleton(node), timeout, maxAttempts, poolConfig);
    }

    public LogtubeJedisCluster(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(Collections.singleton(node), connectionTimeout, soTimeout, maxAttempts, poolConfig);
        this.connectionHandler = new LogtubeJedisSlotBasedConnectionHandler(Collections.singleton(node), poolConfig, connectionTimeout, soTimeout);
    }

    public LogtubeJedisCluster(HostAndPort node, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig) {
        super(Collections.singleton(node), connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
        this.connectionHandler = new LogtubeJedisSlotBasedConnectionHandler(Collections.singleton(node), poolConfig, connectionTimeout, soTimeout, password);
    }

    public LogtubeJedisCluster(Set<HostAndPort> nodes) {
        this(nodes, 2000);
    }

    public LogtubeJedisCluster(Set<HostAndPort> nodes, int timeout) {
        this(nodes, timeout, 5);
    }

    public LogtubeJedisCluster(Set<HostAndPort> nodes, int timeout, int maxAttempts) {
        this(nodes, timeout, maxAttempts, new GenericObjectPoolConfig());
    }

    public LogtubeJedisCluster(Set<HostAndPort> nodes, GenericObjectPoolConfig poolConfig) {
        this(nodes, 2000, 5, poolConfig);
    }

    public LogtubeJedisCluster(Set<HostAndPort> nodes, int timeout, GenericObjectPoolConfig poolConfig) {
        this(nodes, timeout, 5, poolConfig);
    }

    public LogtubeJedisCluster(Set<HostAndPort> jedisClusterNode, int timeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, timeout, maxAttempts, poolConfig);
        this.connectionHandler = new LogtubeJedisSlotBasedConnectionHandler(jedisClusterNode, poolConfig, timeout);
    }

    public LogtubeJedisCluster(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, poolConfig);
        this.connectionHandler = new LogtubeJedisSlotBasedConnectionHandler(jedisClusterNode, poolConfig, connectionTimeout, soTimeout);
    }

    public LogtubeJedisCluster(Set<HostAndPort> jedisClusterNode, int connectionTimeout, int soTimeout, int maxAttempts, String password, GenericObjectPoolConfig poolConfig) {
        super(jedisClusterNode, connectionTimeout, soTimeout, maxAttempts, password, poolConfig);
        this.connectionHandler = new LogtubeJedisSlotBasedConnectionHandler(jedisClusterNode, poolConfig, connectionTimeout, soTimeout, password);
    }
}

