/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.redis;

import io.github.logtube.redis.LogtubeRedisClient;
import java.net.URI;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.InvalidURIException;
import redis.clients.util.JedisURIHelper;

public class LogtubeJedis
extends Jedis {
    public LogtubeJedis() {
        this.client = new LogtubeRedisClient();
    }

    public LogtubeJedis(String host) {
        URI uri = URI.create(host);
        if (uri.getScheme() != null && uri.getScheme().equals("redis")) {
            this.initializeClientFromURI(uri);
        } else {
            this.client = new LogtubeRedisClient(host);
        }
    }

    public LogtubeJedis(String host, int port) {
        this.client = new LogtubeRedisClient(host, port);
    }

    public LogtubeJedis(String host, int port, int connectionTimeout, int soTimeout, boolean ssl, SSLSocketFactory sslSocketFactory, SSLParameters sslParameters, HostnameVerifier hostnameVerifier) {
        this.client = new LogtubeRedisClient(host, port, ssl, sslSocketFactory, sslParameters, hostnameVerifier);
        this.client.setConnectionTimeout(connectionTimeout);
        this.client.setSoTimeout(soTimeout);
    }

    private void initializeClientFromURI(URI uri) {
        int dbIndex;
        if (!JedisURIHelper.isValid((URI)uri)) {
            throw new InvalidURIException(String.format("Cannot open Redis connection due invalid URI. %s", uri.toString()));
        }
        this.client = new LogtubeRedisClient(uri.getHost(), uri.getPort(), uri.getScheme().equals("rediss"));
        String password = JedisURIHelper.getPassword((URI)uri);
        if (password != null) {
            this.client.auth(password);
            this.client.getStatusCodeReply();
        }
        if ((dbIndex = JedisURIHelper.getDBIndex((URI)uri)) > 0) {
            this.client.select(dbIndex);
            this.client.getStatusCodeReply();
            this.client.setDb((long)dbIndex);
        }
    }
}

