/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.perf;

import io.github.logtube.core.IMutableEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class XPerfCommitter {
    private final IMutableEvent event;
    private final long startTime = System.currentTimeMillis();

    public XPerfCommitter(@NotNull IMutableEvent event) {
        this.event = event;
    }

    @NotNull
    @Contract(value="_->this")
    public XPerfCommitter setAction(String action) {
        this.event.extra("action", action);
        return this;
    }

    @NotNull
    @Contract(value="_->this")
    public XPerfCommitter setActionDetail(String actionDetail) {
        this.event.extra("action_detail", actionDetail);
        return this;
    }

    @NotNull
    @Contract(value="_->this")
    public XPerfCommitter setValueInteger(long value) {
        this.event.extra("value_integer", value);
        return this;
    }

    public void commit() {
        this.event.xDuration(System.currentTimeMillis() - this.startTime).commit();
    }
}

