/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.http;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.concurrent.atomic.LongAdder;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.jetbrains.annotations.NotNull;

public class LogtubeHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private final LongAdder responseSize = new LongAdder();

    public LogtubeHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public long getResponseSize() {
        return this.responseSize.longValue();
    }

    public PrintWriter getWriter() throws IOException {
        return new WrappedPrintWrapper(super.getWriter());
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new WrappedServletOutputStream(super.getOutputStream());
    }

    private class WrappedWriter
    extends Writer {
        @NotNull
        private final Writer parent;

        WrappedWriter(Writer parent) {
            super((Object)parent);
            this.parent = parent;
        }

        @Override
        public void write(@NotNull char[] chars, int off, int len) throws IOException {
            this.parent.write(chars, off, len);
            LogtubeHttpServletResponseWrapper.this.responseSize.add(len);
        }

        @Override
        public void flush() throws IOException {
            this.parent.flush();
        }

        @Override
        public void close() throws IOException {
            this.parent.close();
        }
    }

    private class WrappedPrintWrapper
    extends PrintWriter {
        WrappedPrintWrapper(PrintWriter parent) {
            super(new WrappedWriter(parent));
        }
    }

    private class WrappedServletOutputStream
    extends ServletOutputStream {
        @NotNull
        private final ServletOutputStream parent;

        WrappedServletOutputStream(ServletOutputStream parent) {
            this.parent = parent;
        }

        public boolean isReady() {
            return this.parent.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.parent.setWriteListener(writeListener);
        }

        public void write(int i) throws IOException {
            this.parent.write(i);
            LogtubeHttpServletResponseWrapper.this.responseSize.increment();
        }
    }
}

