/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.http;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import io.github.logtube.http.LogtubeHttpServletResponseWrapper;
import io.github.logtube.utils.Requests;
import io.github.logtube.utils.Strings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogtubeHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogtubeHttpServletResponseWrapper.class);
    private final byte[] body;
    private final Map<String, String[]> paramsMap = new HashMap<String, String[]>();
    private String characterEncoding = Charset.defaultCharset().toString();
    private boolean isUrlencodedBody = false;

    public LogtubeHttpServletRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.body = Requests.readBody(request);
        this.isUrlencodedBody = Requests.hasFormUrlencodedBody(request);
        if (request.getCharacterEncoding() != null && request.getCharacterEncoding().trim().length() > 0) {
            this.characterEncoding = request.getCharacterEncoding();
        }
        this.initParameters();
    }

    public ServletInputStream getInputStream() {
        return new InputStreamWrapper();
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getParameter(String name) {
        String[] value = this.paramsMap.get(name);
        if (value != null && value.length > 0) {
            return value[0];
        }
        return super.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.paramsMap;
    }

    public Enumeration<String> getParameterNames() {
        if (this.paramsMap.size() <= 0) {
            return super.getParameterNames();
        }
        return Collections.enumeration(this.paramsMap.keySet());
    }

    public String[] getParameterValues(String name) {
        if (this.paramsMap.containsKey(name)) {
            return this.paramsMap.get(name);
        }
        return super.getParameterValues(name);
    }

    @NotNull
    public String getBody() {
        return new String(this.body);
    }

    @NotNull
    public ArrayList<String> getParams() {
        ArrayList<String> params = new ArrayList<String>();
        try {
            if (this.isUrlencodedBody) {
                params.add(URLDecoder.decode(this.getBody(), this.characterEncoding));
            } else {
                params.add(this.getBody());
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.info(e.getMessage(), (Throwable)e);
        }
        return params;
    }

    private void initParameters() {
        try {
            this.paramsMap.putAll(super.getParameterMap());
            String paramStr = new String(this.body);
            if (Strings.isEmpty(paramStr)) {
                return;
            }
            if (Requests.hasJsonBody((HttpServletRequest)this)) {
                this.processJsonBody(paramStr);
            } else if (this.isUrlencodedBody) {
                this.processFormUrlencoded(paramStr);
            }
        }
        catch (Throwable t) {
            LOGGER.debug(t.getMessage(), t);
        }
    }

    private void processFormUrlencoded(String paramStr) throws UnsupportedEncodingException {
        String[] paramVals;
        for (String paramVal : paramVals = paramStr.split("&")) {
            String[] param = paramVal.split("=");
            if (param == null || param.length != 2) continue;
            String key = URLDecoder.decode(param[0], this.characterEncoding);
            String value = URLDecoder.decode(param[1], this.characterEncoding);
            if (this.paramsMap.containsKey(key)) {
                String[] vals = this.paramsMap.get(key);
                String[] newVals = new String[vals.length + 1];
                System.arraycopy(vals, 0, newVals, 0, vals.length);
                newVals[vals.length] = value;
                this.paramsMap.put(key, newVals);
                continue;
            }
            this.paramsMap.put(key, new String[]{value});
        }
    }

    private void processJsonBody(String paramStr) {
        Gson gson = new GsonBuilder().registerTypeAdapter(new TypeToken<TreeMap<String, Object>>(){}.getType(), (Object)new JsonDeserializer<TreeMap<String, Object>>(){

            public TreeMap<String, Object> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
                if (json.isJsonObject()) {
                    JsonObject jsonObject = json.getAsJsonObject();
                    jsonObject.entrySet().stream().forEach(e -> treeMap.put((String)e.getKey(), e.getValue()));
                }
                return treeMap;
            }
        }).create();
        Map map = (Map)gson.fromJson(paramStr, new TypeToken<TreeMap<String, Object>>(){}.getType());
        if (map != null) {
            map.entrySet().stream().filter(p -> p.getValue() instanceof JsonPrimitive).forEach(e -> this.paramsMap.put((String)e.getKey(), new String[]{String.valueOf(e.getValue())}));
        }
    }

    public class InputStreamWrapper
    extends ServletInputStream {
        private final ByteArrayInputStream inputStream;

        public InputStreamWrapper() {
            this.inputStream = new ByteArrayInputStream(LogtubeHttpServletRequestWrapper.this.body);
        }

        public boolean isFinished() {
            return this.inputStream.available() == 0;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            try {
                readListener.onDataAvailable();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int read() {
            return this.inputStream.read();
        }
    }
}

