/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.http;

import io.github.logtube.Logtube;
import io.github.logtube.http.HttpAccessEventCommitter;
import io.github.logtube.http.LogtubeHttpServletRequestWrapper;
import io.github.logtube.http.LogtubeHttpServletResponseWrapper;
import io.github.logtube.utils.HttpIgnore;
import io.github.logtube.utils.Requests;
import io.github.logtube.utils.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.NotNull;

public class LogtubeHttpFilter
implements Filter {
    private static final String ONCE_KEY = "io.github.logtube.http.filter.once";
    public static HttpIgnore[] GLOBAL_HTTP_IGNORES = new HttpIgnore[0];
    private HttpIgnore[] LOCAL_HTTP_IGNORES = new HttpIgnore[0];

    public void init(FilterConfig filterConfig) throws ServletException {
        ArrayList httpIgnores = new ArrayList();
        String exclusionListStr = filterConfig.getInitParameter("exclusionList");
        if (!Strings.isEmpty(exclusionListStr)) {
            Arrays.stream(exclusionListStr.split(",")).map(Strings::safeNormalize).forEach(s -> httpIgnores.add(new HttpIgnore("GET", (String)s)));
        }
        this.LOCAL_HTTP_IGNORES = httpIgnores.toArray(new HttpIgnore[0]);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(ONCE_KEY) != null) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(ONCE_KEY, (Object)true);
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        for (HttpIgnore hi : this.LOCAL_HTTP_IGNORES) {
            if (!hi.method.equalsIgnoreCase(httpRequest.getMethod()) || !hi.path.equals(httpRequest.getRequestURI())) continue;
            chain.doFilter(request, response);
            return;
        }
        for (HttpIgnore hi : GLOBAL_HTTP_IGNORES) {
            if (!hi.method.equalsIgnoreCase(httpRequest.getMethod()) || !hi.path.equals(httpRequest.getRequestURI())) continue;
            chain.doFilter(request, response);
            return;
        }
        this.process(httpRequest, httpResponse, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        request = this.wrapRequest(request);
        response = this.wrapResponse(response);
        this.setupRootLogger(request, response);
        HttpAccessEventCommitter event = new HttpAccessEventCommitter().setServletRequest((ServletRequest)request);
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            event.setServletResponse((ServletResponse)response);
        }
        finally {
            event.commit();
            this.resetRootLogger();
        }
    }

    @NotNull
    private HttpServletRequest wrapRequest(@NotNull HttpServletRequest request) throws IOException {
        if (Requests.hasJsonBody(request) || Requests.hasFormUrlencodedBody(request)) {
            return new LogtubeHttpServletRequestWrapper(request);
        }
        return request;
    }

    @NotNull
    private HttpServletResponse wrapResponse(@NotNull HttpServletResponse response) {
        return new LogtubeHttpServletResponseWrapper(response);
    }

    private void setupRootLogger(HttpServletRequest request, HttpServletResponse response) {
        Logtube.getProcessor().setPath(request.getRequestURI());
        Logtube.getProcessor().setCrid(request.getHeader("X-Correlation-ID"));
        Logtube.getProcessor().setCrsrc(request.getHeader("X-Correlation-Src"));
        response.setHeader("X-Correlation-ID", Logtube.getProcessor().getCrid());
    }

    private void resetRootLogger() {
        Logtube.getProcessor().clearContext();
    }

    public void destroy() {
    }
}

