/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.http;

import io.github.logtube.Logtube;
import io.github.logtube.core.IMutableEvent;
import io.github.logtube.http.LogtubeHttpServletRequestWrapper;
import io.github.logtube.http.LogtubeHttpServletResponseWrapper;
import io.github.logtube.utils.Flatten;
import java.util.ArrayList;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class HttpAccessEventCommitter {
    @NotNull
    private final IMutableEvent event = Logtube.getLogger(HttpAccessEventCommitter.class).topic("x-access");
    private final long startAt = System.currentTimeMillis();
    private HttpServletRequest httpRequest;

    @Contract(value="_ -> this")
    @NotNull
    public HttpAccessEventCommitter setServletRequest(@NotNull ServletRequest request) {
        if (!(request instanceof HttpServletRequest)) {
            return this;
        }
        this.httpRequest = (HttpServletRequest)request;
        this.event.extra("method", this.httpRequest.getMethod()).extra("host", this.httpRequest.getServerName()).extra("query", this.httpRequest.getQueryString()).extra("header_user_token", this.httpRequest.getHeader("UserToken")).extra("header_app_info", Flatten.flattenJSON(this.httpRequest.getHeader("X-Defined-AppInfo"))).extra("header_ver_info", Flatten.flattenJSON(this.httpRequest.getHeader("X-Defined-VerInfo"))).extra("remote_addr", HttpAccessEventCommitter.determineRemoteAddr(this.httpRequest));
        return this;
    }

    @NotNull
    private static String determineRemoteAddr(HttpServletRequest request) {
        String[] xffs;
        String xff = request.getHeader("X-Forwarded-For");
        if (xff != null && !xff.isEmpty() && (xffs = xff.split(",")).length > 0) {
            return xffs[0].trim();
        }
        String ri = request.getHeader("X-Real-IP");
        if (ri != null && !ri.isEmpty()) {
            return ri.trim();
        }
        return request.getRemoteAddr();
    }

    @Contract(value="_ -> this")
    @NotNull
    public HttpAccessEventCommitter setServletResponse(@NotNull ServletResponse response) {
        if (!(response instanceof HttpServletResponse)) {
            return this;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        this.event.extra("status", httpResponse.getStatus());
        if (response instanceof LogtubeHttpServletResponseWrapper) {
            this.event.extra("response_size", ((LogtubeHttpServletResponseWrapper)response).getResponseSize());
        }
        return this;
    }

    public void commit() {
        ArrayList<String> params = null;
        params = this.httpRequest instanceof LogtubeHttpServletRequestWrapper ? ((LogtubeHttpServletRequestWrapper)this.httpRequest).getParams() : Flatten.flattenParameters(this.httpRequest.getParameterMap());
        this.event.xDuration(System.currentTimeMillis() - this.startAt);
        if (params != null) {
            this.event.extra("params", String.join((CharSequence)",", params));
        }
        this.event.commit();
    }
}

