/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.druid;

import com.alibaba.druid.proxy.jdbc.ConnectionProxy;
import com.alibaba.druid.proxy.jdbc.ConnectionProxyImpl;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.SQLUtils;
import io.github.logtube.Logtube;
import io.github.logtube.core.IMutableEvent;
import io.github.logtube.utils.Hex;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DruidTrackEventCommitter {
    private final IMutableEvent event = Logtube.getLogger(DruidTrackEventCommitter.class).topic("x-druid-track");
    private final long startTime = System.currentTimeMillis();
    private final Pattern hostPattern = Pattern.compile("(?<=//)((\\w)+(\\.)*)+\\w+");
    private final Pattern dbPattern = Pattern.compile("(?<=/)([a-zA-Z][a-zA-Z0-9_]*)");
    private final Pattern digestPattern = Pattern.compile("(\\'[A-Za-z0-9_-]*\\')|(\\\"[A-Za-z0-9_-]*\\\")|\\d+");
    @NotNull
    private StatementProxy statement;

    @Contract(value="_ -> this")
    @NotNull
    public DruidTrackEventCommitter setThrowable(@Nullable Throwable e) {
        if (e == null) {
            this.event.extra("error", null);
            return this;
        }
        this.event.extra("error", e.getMessage());
        return this;
    }

    public void commit() {
        try {
            this.event.xDuration(System.currentTimeMillis() - this.startTime);
            ConnectionProxy connection = this.statement.getConnectionProxy();
            if (connection instanceof ConnectionProxyImpl) {
                Matcher dbMatcher;
                String url = ((ConnectionProxyImpl)connection).getDirectDataSource().getUrl();
                Matcher hostMatcher = this.hostPattern.matcher(url);
                if (hostMatcher.find()) {
                    this.event.extra("db_host", hostMatcher.group());
                }
                if ((dbMatcher = this.dbPattern.matcher(url)).find(14)) {
                    this.event.extra("db_name", dbMatcher.group());
                }
            }
            String sql = this.statement.getLastExecuteSql();
            String afterReplaceIn = sql.replaceAll("\\([\\?\\, ]*\\)", "(:in_parameters)");
            this.event.extra("sql_digest", Hex.md5(this.digestPattern.matcher(afterReplaceIn).replaceAll(":paramValue")));
            String rawSql = sql;
            int parametersSize = this.statement.getParametersSize();
            if (parametersSize > 0) {
                ArrayList<Object> parameters = new ArrayList<Object>(parametersSize);
                for (int i = 0; i < parametersSize; ++i) {
                    JdbcParameter jdbcParam = this.statement.getParameter(i);
                    parameters.add(jdbcParam != null ? jdbcParam.getValue() : null);
                }
                String dbType = this.statement.getConnectionProxy().getDirectDataSource().getDbType();
                rawSql = SQLUtils.format((String)sql, (String)dbType, parameters, (SQLUtils.FormatOption)SQLUtils.DEFAULT_LCASE_FORMAT_OPTION);
            }
            this.event.extra("sql", rawSql);
        }
        catch (Throwable t) {
            this.setThrowable(t);
        }
        this.event.commit();
    }

    @Contract(value="_ -> this")
    @NotNull
    public DruidTrackEventCommitter setStatement(@NotNull StatementProxy statement) {
        this.statement = statement;
        return this;
    }

    public void setAffectedRows(long affectedRows) {
        this.event.extra("affected_rows", affectedRows);
    }
}

