/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.core.serializers;

import io.github.logtube.core.IEvent;
import io.github.logtube.core.IEventSerializer;
import io.github.logtube.utils.Dates;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class EventConsoleSerializer
implements IEventSerializer {
    @Override
    public void serialize(@NotNull IEvent e, @NotNull Writer w) throws IOException {
        Map<String, Object> extra;
        w.write(Dates.formatLineTimestamp(e.getTimestamp()));
        w.write(" [");
        w.write(e.getTopic());
        w.write("] (");
        w.write(e.getCrsrc());
        w.write("/");
        w.write(e.getCrid());
        w.write(") ");
        if (e.getKeyword() != null) {
            w.write("[");
            w.write(e.getKeyword());
            w.write("] ");
        }
        if ((extra = e.getExtra()) != null && !extra.isEmpty()) {
            w.write(123);
            for (Map.Entry<String, Object> entry : extra.entrySet()) {
                w.write(entry.getKey());
                w.write(61);
                w.write(entry.getValue().toString());
                w.write(44);
            }
            w.write("} ");
        }
        if (e.getMessage() != null) {
            w.write(e.getMessage());
        }
    }
}

