/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.core.processors;

import io.github.logtube.core.IEvent;
import io.github.logtube.core.IEventContext;
import io.github.logtube.core.IEventOutput;
import io.github.logtube.core.IEventProcessor;
import io.github.logtube.core.IMutableEvent;
import io.github.logtube.core.context.EventContext;
import io.github.logtube.core.events.Event;
import io.github.logtube.utils.Hex;
import io.github.logtube.utils.ILifeCycle;
import io.github.logtube.utils.LifeCycle;
import io.github.logtube.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventProcessor
extends LifeCycle
implements IEventProcessor {
    public static final String UNKNOWN_PROJECT = "unknown-project";
    @Nullable
    private String hostname = null;
    @Nullable
    private String project = null;
    @Nullable
    private String env = null;
    @NotNull
    private List<IEventOutput> outputs = new ArrayList<IEventOutput>();
    @NotNull
    private Map<String, String> topicMappings = new HashMap<String, String>();
    private final CridThreadLocal cridThreadLocal = new CridThreadLocal();
    private final CrsrcThreadLocal crsrcThreadLocal = new CrsrcThreadLocal();
    private final ThreadLocal<String> pathThreadLocal = new InheritableThreadLocal<String>();
    private final ThreadLocal<String> pathDigestThreadLocal = new InheritableThreadLocal<String>();

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(@Nullable String hostname) {
        this.hostname = hostname;
    }

    @Override
    @NotNull
    public String getProject() {
        return this.project == null ? UNKNOWN_PROJECT : this.project;
    }

    public void setProject(@Nullable String project) {
        this.project = project;
    }

    @Nullable
    public String getEnv() {
        return this.env;
    }

    public void setEnv(@Nullable String env) {
        this.env = env;
    }

    public void setOutputs(@NotNull List<IEventOutput> outputs) {
        this.outputs = outputs;
    }

    @NotNull
    public List<IEventOutput> getOutputs() {
        return this.outputs;
    }

    public void addOutput(@NotNull IEventOutput output) {
        this.outputs.add(output);
    }

    public void setTopicMappings(@Nullable Map<String, String> topicMappings) {
        this.topicMappings = topicMappings == null ? new HashMap<String, String>() : topicMappings;
    }

    @NotNull
    private String resolveTopic(@NotNull String topic) {
        return this.topicMappings.getOrDefault(topic, topic);
    }

    @Override
    @NotNull
    public IEventContext captureContext() {
        return new EventContext(this.getCrid(), this.getCrsrc(), this.getPath());
    }

    @Override
    public void clearContext() {
        this.cridThreadLocal.remove();
        this.crsrcThreadLocal.remove();
        this.pathDigestThreadLocal.remove();
        this.pathThreadLocal.remove();
    }

    @Override
    public void setCrid(@Nullable String crid) {
        if (crid != null) {
            this.cridThreadLocal.set(crid);
        } else {
            this.cridThreadLocal.set(Hex.randomHex16());
        }
    }

    @Override
    public void setCrsrc(@Nullable String crsrc) {
        if (crsrc != null) {
            this.crsrcThreadLocal.set(crsrc);
        } else {
            this.crsrcThreadLocal.remove();
        }
    }

    @Override
    @NotNull
    public String getCrid() {
        return (String)this.cridThreadLocal.get();
    }

    @Override
    @NotNull
    public String getCrsrc() {
        return (String)this.crsrcThreadLocal.get();
    }

    @Override
    public void setPath(@Nullable String path) {
        if ((path = Strings.normalize(path)) != null) {
            this.pathDigestThreadLocal.set(Hex.md5(path.replaceAll("(\\b/)\\d+", "/:num")));
            this.pathThreadLocal.set(path);
        }
    }

    @Override
    @Nullable
    public String getPath() {
        return this.pathThreadLocal.get();
    }

    @Override
    @Nullable
    public String getPathDigest() {
        return this.pathDigestThreadLocal.get();
    }

    @Override
    @NotNull
    public IMutableEvent event() {
        return new LoggerEvent().timestamp(System.currentTimeMillis());
    }

    private IEvent afterProcess(@NotNull IMutableEvent e) {
        return e.topic(this.resolveTopic(e.getTopic())).hostname(this.getHostname()).env(this.getEnv()).project(this.getProject()).crid(this.getCrid()).crsrc(this.getCrsrc()).xPath(this.getPath()).xPathDigest(this.getPathDigest());
    }

    @Override
    public void doStart() {
        super.doStart();
        this.outputs.forEach(ILifeCycle::start);
    }

    @Override
    public void doStop() {
        this.outputs.forEach(ILifeCycle::stop);
        super.doStop();
    }

    private static class CrsrcThreadLocal
    extends InheritableThreadLocal<String> {
        private CrsrcThreadLocal() {
        }

        @Override
        protected String initialValue() {
            return "-";
        }
    }

    private static class CridThreadLocal
    extends InheritableThreadLocal<String> {
        private CridThreadLocal() {
        }

        @Override
        protected String initialValue() {
            return "-";
        }
    }

    private class LoggerEvent
    extends Event {
        private LoggerEvent() {
        }

        @Override
        public void commit() {
            if (!EventProcessor.this.isStarted) {
                return;
            }
            EventProcessor.this.getOutputs().forEach(o -> {
                try {
                    o.appendEvent(EventProcessor.this.afterProcess(this));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }

        @Override
        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }
    }
}

