/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.core.outputs;

import io.github.logtube.core.IEvent;
import io.github.logtube.core.IEventSerializer;
import io.github.logtube.core.outputs.BaseEventOutput;
import io.github.logtube.core.serializers.EventJSONSerializer;
import io.github.logtube.utils.SPTPClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import org.jetbrains.annotations.NotNull;

public class EventRemoteOutput
extends BaseEventOutput {
    private final IEventSerializer serializer = new EventJSONSerializer();
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private final OutputStreamWriter bufferWriter = new OutputStreamWriter(this.buffer);
    private final String[] hosts;
    private SPTPClient client;

    public EventRemoteOutput(String[] hosts) {
        this.hosts = hosts;
    }

    @Override
    public void doStart() {
        super.doStart();
        this.client = new SPTPClient(this.hosts);
    }

    @Override
    public void doStop() {
        this.client = null;
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAppendEvent(@NotNull IEvent e) {
        SPTPClient client = this.client;
        if (client == null) {
            return;
        }
        EventRemoteOutput eventRemoteOutput = this;
        synchronized (eventRemoteOutput) {
            this.buffer.reset();
            try {
                this.serializer.serialize(e, this.bufferWriter);
                this.bufferWriter.flush();
                client.send(this.buffer.toByteArray());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

