/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.core.outputs;

import io.github.logtube.core.IEvent;
import io.github.logtube.core.IEventSerializer;
import io.github.logtube.core.outputs.BaseEventOutput;
import io.github.logtube.core.serializers.EventRedisSerializer;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class EventRedisOutput
extends BaseEventOutput {
    private static final int QUEUE_CAPACITY = 1024;
    private final IEventSerializer serializer = new EventRedisSerializer();
    private final String[] hosts;
    private final String key;
    @NotNull
    private final ArrayBlockingQueue<String> queue = new ArrayBlockingQueue(1024);
    private EventRedisOutputWorker worker = null;

    @NotNull
    private JedisPool createJedisPool(@NotNull String host) {
        String[] split = host.split(":");
        if (split.length == 2) {
            return new JedisPool(split[0], Integer.valueOf(split[1]).intValue());
        }
        return new JedisPool(host);
    }

    public EventRedisOutput(String[] hosts, String key) {
        this.hosts = hosts;
        this.key = key;
    }

    @Override
    public void doStart() {
        super.doStart();
        this.worker = new EventRedisOutputWorker(this.hosts, this.key);
        this.worker.start();
    }

    @Override
    public void doStop() {
        this.worker.exit();
        try {
            this.worker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.worker = null;
        super.doStop();
    }

    @Override
    public void doAppendEvent(@NotNull IEvent e) {
        this.queue.offer(this.serializer.toString(e));
    }

    private class EventRedisOutputWorker
    extends Thread {
        private final ArrayList<JedisPool> pools;
        private final String key;
        private final AtomicLong cursor;
        private boolean shouldExit;

        EventRedisOutputWorker(String[] hosts, String key) {
            super("logtube-EventRedisOutputWorker");
            this.pools = new ArrayList();
            this.cursor = new AtomicLong();
            this.shouldExit = false;
            for (String host : hosts) {
                this.pools.add(EventRedisOutput.this.createJedisPool(host));
            }
            this.key = key;
        }

        public void exit() {
            this.shouldExit = true;
        }

        @NotNull
        private Jedis getJedis(int retry) {
            if (retry < 1) {
                throw new JedisConnectionException("failed to find a reachable redis instance");
            }
            long index = this.cursor.addAndGet(1L);
            if (index < 0L) {
                index = 0L;
            }
            try {
                return this.pools.get((int)(index % (long)this.pools.size())).getResource();
            }
            catch (Exception exception) {
                return this.getJedis(retry - 1);
            }
        }

        @NotNull
        private Jedis getJedis() {
            return this.getJedis(this.pools.size());
        }

        @Override
        public void run() {
            while (!this.shouldExit) {
                String message = null;
                try {
                    message = (String)EventRedisOutput.this.queue.poll(5L, TimeUnit.SECONDS);
                }
                catch (Exception ignored) {
                    continue;
                }
                if (message == null) continue;
                try {
                    Jedis jedis = this.getJedis();
                    Throwable throwable = null;
                    try {
                        jedis.rpush(this.key, new String[]{message});
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (jedis == null) continue;
                        if (throwable != null) {
                            try {
                                jedis.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        jedis.close();
                    }
                }
                catch (Exception exception) {}
            }
            this.pools.clear();
        }
    }
}

