/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.core.outputs;

import io.github.logtube.core.IEvent;
import io.github.logtube.core.outputs.BaseEventOutput;
import io.github.logtube.utils.IntervalChecker;
import io.github.logtube.utils.SignalChecker;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public abstract class BaseFileOutput
extends BaseEventOutput {
    private static final int QUEUE_CAPACITY = 1024;
    private static final String SUBDIR_OTHERS = "others";
    private static final char[] NEW_LINE = new char[]{'\r', '\n'};
    private final String dir;
    private final SignalChecker signalChecker;
    private final IntervalChecker signalIntervalChecker = new IntervalChecker(30000L);
    private final HashMap<String, FileWriter> writers = new HashMap();
    private final Map<String, String> subdirMappings;
    @NotNull
    private final ArrayBlockingQueue<IEvent> queue = new ArrayBlockingQueue(1024);
    private EventFileOutputWorker worker = null;

    public BaseFileOutput(@NotNull String dir, Map<String, String> subdirMappings, @NotNull String signal) {
        this.dir = dir;
        this.subdirMappings = subdirMappings;
        this.signalChecker = new SignalChecker(signal);
    }

    private void closeWriters() throws IOException {
        for (Map.Entry<String, FileWriter> entry : this.writers.entrySet()) {
            entry.getValue().close();
        }
        this.writers.clear();
    }

    private void closeWritersIfNeeded() throws IOException {
        if (!this.signalIntervalChecker.check()) {
            return;
        }
        if (!this.signalChecker.check()) {
            return;
        }
        this.closeWriters();
    }

    private synchronized FileWriter getWriter(@NotNull IEvent e) throws IOException {
        this.closeWritersIfNeeded();
        FileWriter w = this.writers.get(e.getTopic());
        if (w == null) {
            String wildcard;
            String subdir = this.subdirMappings.get(e.getTopic());
            Path path = subdir == null ? ((wildcard = this.subdirMappings.get("ALL")) != null ? Paths.get(this.dir, wildcard, e.getEnv() + "." + e.getTopic() + "." + e.getProject() + ".log") : Paths.get(this.dir, SUBDIR_OTHERS, e.getEnv() + "." + e.getTopic() + "." + e.getProject() + ".log")) : Paths.get(this.dir, subdir, e.getEnv() + "." + e.getTopic() + "." + e.getProject() + ".log");
            w = new FileWriter(path.toAbsolutePath().toString(), true);
            this.writers.put(e.getTopic(), w);
        }
        return w;
    }

    @Override
    public void doAppendEvent(@NotNull IEvent e) {
        this.queue.offer(e);
    }

    @Override
    public void doStart() {
        super.doStart();
        Paths.get(this.dir, new String[0]).toFile().mkdirs();
        Paths.get(this.dir, SUBDIR_OTHERS).toFile().mkdirs();
        new HashSet<String>(this.subdirMappings.values()).forEach(subdir -> Paths.get(this.dir, subdir).toFile().mkdirs());
        this.worker = new EventFileOutputWorker();
        this.worker.start();
    }

    @Override
    public void doStop() {
        this.worker.exit();
        try {
            this.worker.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.worker = null;
        try {
            this.closeWriters();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.doStop();
    }

    abstract void serializeLine(@NotNull IEvent var1, @NotNull Writer var2) throws IOException;

    private class EventFileOutputWorker
    extends Thread {
        private boolean shouldExit;

        public EventFileOutputWorker() {
            super("logtube-FileOutputWorker");
            this.shouldExit = false;
            this.setDaemon(true);
        }

        public void exit() {
            this.shouldExit = true;
        }

        @Override
        public void run() {
            while (!this.shouldExit) {
                IEvent e = null;
                try {
                    e = (IEvent)BaseFileOutput.this.queue.poll(5L, TimeUnit.SECONDS);
                }
                catch (Exception ignored) {
                    continue;
                }
                if (e == null) continue;
                try {
                    FileWriter w = BaseFileOutput.this.getWriter(e);
                    BaseFileOutput.this.serializeLine(e, w);
                    w.write(NEW_LINE);
                    w.flush();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

