/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.core.events;

import io.github.logtube.core.IMutableEvent;
import io.github.logtube.utils.Strings;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Event
implements IMutableEvent {
    public static final String UNKNOWN_HOSTNAME = "unknown-host";
    public static final String UNKNOWN_PROJECT = "unknown-project";
    public static final String UNKNOWN_ENV = "unknown-env";
    public static final String UNKNOWN_TOPIC = "unknown-topic";
    public static final String UNKNOWN_CRID = "-";
    public static final String UNKNOWN_CRSRC = "-";
    private long timestamp = 0L;
    @Nullable
    private String hostname = null;
    @Nullable
    private String env = null;
    @Nullable
    private String project = null;
    @Nullable
    private String topic = null;
    @Nullable
    private String crid = null;
    @Nullable
    private String crsrc = null;
    @Nullable
    private String message = null;
    @Nullable
    private String keyword = null;
    @Nullable
    private Map<String, Object> extra;

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    @NotNull
    public String getHostname() {
        return this.hostname == null ? UNKNOWN_HOSTNAME : this.hostname;
    }

    @Override
    public void setHostname(@Nullable String hostname) {
        this.hostname = hostname;
    }

    @Override
    @NotNull
    public String getEnv() {
        return this.env == null ? UNKNOWN_ENV : this.env;
    }

    @Override
    public void setEnv(@Nullable String env) {
        this.env = env;
    }

    @Override
    @NotNull
    public String getProject() {
        return this.project == null ? UNKNOWN_PROJECT : this.project;
    }

    @Override
    public void setProject(@Nullable String project) {
        this.project = project;
    }

    @Override
    @NotNull
    public String getTopic() {
        return this.topic == null ? UNKNOWN_TOPIC : this.topic;
    }

    @Override
    public void setTopic(@Nullable String topic) {
        this.topic = topic;
    }

    @Override
    @NotNull
    public String getCrid() {
        return this.crid == null ? "-" : this.crid;
    }

    @Override
    public void setCrid(@Nullable String crid) {
        this.crid = crid;
    }

    @Override
    @NotNull
    public String getCrsrc() {
        return this.crsrc == null ? "-" : this.crsrc;
    }

    @Override
    public void setCrsrc(@Nullable String crsrc) {
        this.crsrc = crsrc;
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(@Nullable String message) {
        this.message = Strings.normalize(message);
    }

    @Override
    @Nullable
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public void setKeyword(@Nullable String keyword) {
        this.keyword = Strings.normalize(keyword);
    }

    @Override
    @Nullable
    public Map<String, Object> getExtra() {
        return this.extra;
    }

    @Override
    public void setExtra(@Nullable Map<String, Object> extra) {
        this.extra = extra;
    }

    @Override
    public void commit() {
        throw new RuntimeException("never call Event#commit");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Event e = (Event)super.clone();
        if (this.extra != null) {
            e.extra = new HashMap<String, Object>(this.extra);
        }
        return e;
    }
}

