/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.core;

import io.github.logtube.LogtubeConstants;
import io.github.logtube.core.IEvent;
import io.github.logtube.utils.Reflections;
import io.github.logtube.utils.Strings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMutableEvent
extends IEvent {
    public void setTimestamp(long var1);

    public void setHostname(@Nullable String var1);

    public void setEnv(@Nullable String var1);

    public void setProject(@Nullable String var1);

    public void setTopic(@Nullable String var1);

    public void setCrid(@Nullable String var1);

    public void setCrsrc(@Nullable String var1);

    public void setMessage(@Nullable String var1);

    public void setKeyword(@Nullable String var1);

    public void setExtra(@Nullable Map<String, Object> var1);

    public void commit();

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent timestamp(long timestamp) {
        this.setTimestamp(timestamp);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent hostname(@Nullable String hostname) {
        this.setHostname(hostname);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent project(@Nullable String project) {
        this.setProject(project);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent env(@Nullable String env) {
        this.setEnv(env);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent topic(@Nullable String topic) {
        this.setTopic(topic);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent crid(@Nullable String crid) {
        this.setCrid(crid);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent crsrc(@Nullable String crsrc) {
        this.setCrsrc(crsrc);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent message(@Nullable String message) {
        if (message == null) {
            return this;
        }
        String current = this.getMessage();
        if (current == null) {
            this.setMessage(message);
        } else {
            this.setMessage(current + " " + message);
        }
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent keyword(Object ... ks) {
        if (ks == null || ks.length == 0 || ks.length > 100) {
            return this;
        }
        CharSequence[] kws = new String[ks.length];
        for (int i = 0; i < ks.length; ++i) {
            kws[i] = Strings.safeNormalizeKeyword(String.valueOf(ks[i]));
        }
        String current = this.getKeyword();
        if (current == null) {
            this.setKeyword(String.join((CharSequence)",", kws));
        } else {
            this.setKeyword(current + "," + String.join((CharSequence)",", kws));
        }
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    default public IMutableEvent extra(@NotNull String k, @Nullable Object v) {
        Map<String, Object> extra = this.getExtra();
        if (extra == null) {
            if (v == null) {
                return this;
            }
            extra = new HashMap<String, Object>();
        }
        if (v == null) {
            extra.remove(k);
        } else if (v instanceof String || v instanceof Number || v instanceof Boolean) {
            extra.put(k, v);
        } else {
            extra.put(k, v.toString());
        }
        this.setExtra(extra);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent extras(Object ... kvs) {
        if (kvs == null || kvs.length == 0 || kvs.length % 2 != 0) {
            throw new IllegalArgumentException("extras key value not match");
        }
        Map<String, Object> extra = this.getExtra();
        if (extra == null) {
            extra = new HashMap<String, Object>();
        }
        for (int i = 0; i < kvs.length; i += 2) {
            Object k = kvs[i];
            Object v = kvs[i + 1];
            if (k == null) continue;
            if (v == null) {
                extra.remove(k.toString());
                continue;
            }
            if (v instanceof String || v instanceof Number || v instanceof Boolean) {
                extra.put(k.toString(), v);
                continue;
            }
            extra.put(k.toString(), v.toString());
        }
        this.setExtra(extra);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent xPath(@Nullable String path) {
        return this.extra("path", path);
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent xPathDigest(@Nullable String pathDigest) {
        return this.extra("path_digest", pathDigest);
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent xDuration(long duration) {
        return this.extra("duration", duration);
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent xException(@Nullable Throwable t) {
        if (t == null) {
            return this.xExceptionClass(null).xExceptionStack(null);
        }
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return this.xExceptionClass(t.getClass().getCanonicalName()).xExceptionStack(sw.toString());
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent xExceptionStack(@Nullable String stack) {
        if (stack == null) {
            boolean autoStackTrace = false;
            for (String topic : LogtubeConstants.TOPICS_AUTO_STACK_TRACE) {
                if (!topic.equalsIgnoreCase(this.getTopic())) continue;
                autoStackTrace = true;
                break;
            }
            if (autoStackTrace) {
                @Nullable StackTraceElement[] elements = Reflections.getStackTraceElements();
                StringBuilder sb = new StringBuilder();
                for (StackTraceElement element : elements) {
                    if (element == null) continue;
                    sb.append("\tat ");
                    sb.append(element.getClassName());
                    sb.append(".");
                    sb.append(element.getMethodName());
                    sb.append("(");
                    sb.append(element.getFileName());
                    sb.append(":");
                    sb.append(element.getLineNumber());
                    sb.append(")");
                    sb.append("\n");
                }
                return this.extra("exception_stack", sb.toString());
            }
        }
        return this.extra("exception_stack", stack);
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent xExceptionClass(@Nullable String clazz) {
        return this.extra("exception_class", clazz);
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent xThreadName(@Nullable String name) {
        return this.extra("thread_name", name);
    }

    @Contract(value="_,_ -> this")
    @NotNull
    default public IMutableEvent xStackTraceElement(@Nullable StackTraceElement element, @Nullable String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (element == null) {
            return this.extras(prefix + "class_name", null, prefix + "class_line", null, prefix + "method_name", null);
        }
        return this.extras(prefix + "class_name", element.getClassName(), prefix + "class_line", element.getLineNumber(), prefix + "method_name", element.getMethodName());
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent xTargetProject(@Nullable String targetProject) {
        return this.extra("target_project", targetProject);
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent xLogtubeVersion(@NotNull String version) {
        return this.extra("logtube_version", version);
    }

    @Contract(value="_ -> this")
    @NotNull
    default public IMutableEvent xLifecycle(@NotNull String lifecycle) {
        return this.extra("lifecycle", lifecycle);
    }
}

