/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube.core;

import io.github.logtube.core.IEventMiddleware;
import io.github.logtube.core.IMutableEvent;
import io.github.logtube.core.events.NOPEvent;
import io.github.logtube.utils.ITopicAware;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public interface IEventLogger
extends ITopicAware,
Logger {
    @NotNull
    public IEventLogger derive(@NotNull IEventMiddleware var1);

    @NotNull
    public IMutableEvent topic(@NotNull String var1);

    @NotNull
    default public IEventLogger keyword(Object ... keywords) {
        return this.derive(e -> e.keyword(keywords));
    }

    @Deprecated
    @NotNull
    default public IEventLogger withK(Object ... keywords) {
        return this.keyword(keywords);
    }

    default public void message(@NotNull String topic, @NotNull String msg) {
        if (!this.isTopicEnabled(topic)) {
            return;
        }
        this._message(topic, msg, null);
    }

    default public void message(@NotNull String topic, @NotNull String format, @Nullable Object arg) {
        if (!this.isTopicEnabled(topic)) {
            return;
        }
        this.message(topic, format, arg, (Object)null);
    }

    default public void message(@NotNull String topic, @NotNull String format, @Nullable Object arg1, @Nullable Object arg2) {
        if (!this.isTopicEnabled(topic)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.format((String)format, (Object)arg1, (Object)arg2);
        this.message(topic, tp.getMessage(), tp.getThrowable());
    }

    default public void message(@NotNull String topic, @NotNull String format, Object ... arguments) {
        if (!this.isTopicEnabled(topic)) {
            return;
        }
        FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])arguments);
        this.message(topic, tp.getMessage(), tp.getThrowable());
    }

    default public void message(@NotNull String topic, @NotNull String msg, @Nullable Throwable t) {
        if (!this.isTopicEnabled(topic)) {
            return;
        }
        this._message(topic, msg, t);
    }

    default public void _message(@NotNull String topic, @NotNull String msg, @Nullable Throwable t) {
        this.topic(topic).message(msg).xException(t).commit();
    }

    default public boolean isTraceEnabled(Marker marker) {
        return this.isTraceEnabled();
    }

    default public boolean isDebugEnabled(Marker marker) {
        return this.isDebugEnabled();
    }

    default public boolean isInfoEnabled(Marker marker) {
        return this.isInfoEnabled();
    }

    default public boolean isWarnEnabled(Marker marker) {
        return this.isWarnEnabled();
    }

    default public boolean isErrorEnabled(Marker marker) {
        return this.isErrorEnabled();
    }

    default public void trace(String msg) {
        this.message("trace", msg);
    }

    default public void trace(String format, Object arg) {
        this.message("trace", format, arg);
    }

    default public void trace(String format, Object arg1, Object arg2) {
        this.message("trace", format, arg1, arg2);
    }

    default public void trace(String format, Object ... arguments) {
        this.message("trace", format, arguments);
    }

    default public void trace(String msg, Throwable t) {
        this.message("trace", msg, t);
    }

    default public void trace(Marker marker, String msg) {
        this.trace(msg);
    }

    default public void trace(Marker marker, String format, Object arg) {
        this.trace(format, arg);
    }

    default public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.trace(format, arg1, arg2);
    }

    default public void trace(Marker marker, String format, Object ... argArray) {
        this.trace(format, argArray);
    }

    default public void trace(Marker marker, String msg, Throwable t) {
        this.trace(msg, t);
    }

    default public void debug(String msg) {
        this.message("debug", msg);
    }

    default public void debug(String format, Object arg) {
        this.message("debug", format, arg);
    }

    default public void debug(String format, Object arg1, Object arg2) {
        this.message("debug", format, arg1, arg2);
    }

    default public void debug(String format, Object ... arguments) {
        this.message("debug", format, arguments);
    }

    default public void debug(String msg, Throwable t) {
        this.message("debug", msg, t);
    }

    default public void debug(Marker marker, String msg) {
        this.debug(msg);
    }

    default public void debug(Marker marker, String format, Object arg) {
        this.debug(format, arg);
    }

    default public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.debug(format, arg1, arg2);
    }

    default public void debug(Marker marker, String format, Object ... argArray) {
        this.debug(format, argArray);
    }

    default public void debug(Marker marker, String msg, Throwable t) {
        this.debug(msg, t);
    }

    default public void info(String msg) {
        this.message("info", msg);
    }

    default public void info(String format, Object arg) {
        this.message("info", format, arg);
    }

    default public void info(String format, Object arg1, Object arg2) {
        this.message("info", format, arg1, arg2);
    }

    default public void info(String format, Object ... arguments) {
        this.message("info", format, arguments);
    }

    default public void info(String msg, Throwable t) {
        this.message("info", msg, t);
    }

    default public void info(Marker marker, String msg) {
        this.info(msg);
    }

    default public void info(Marker marker, String format, Object arg) {
        this.info(format, arg);
    }

    default public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.info(format, arg1, arg2);
    }

    default public void info(Marker marker, String format, Object ... argArray) {
        this.info(format, argArray);
    }

    default public void info(Marker marker, String msg, Throwable t) {
        this.info(msg, t);
    }

    default public void warn(String msg) {
        this.message("warn", msg);
    }

    default public void warn(String format, Object arg) {
        this.message("warn", format, arg);
    }

    default public void warn(String format, Object arg1, Object arg2) {
        this.message("warn", format, arg1, arg2);
    }

    default public void warn(String format, Object ... arguments) {
        this.message("warn", format, arguments);
    }

    default public void warn(String msg, Throwable t) {
        this.message("warn", msg, t);
    }

    default public void warn(Marker marker, String msg) {
        this.warn(msg);
    }

    default public void warn(Marker marker, String format, Object arg) {
        this.warn(format, arg);
    }

    default public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.warn(format, arg1, arg2);
    }

    default public void warn(Marker marker, String format, Object ... argArray) {
        this.warn(format, argArray);
    }

    default public void warn(Marker marker, String msg, Throwable t) {
        this.warn(msg, t);
    }

    default public void error(String msg) {
        this.message("error", msg);
    }

    default public void error(String format, Object arg) {
        this.message("error", format, arg);
    }

    default public void error(String format, Object arg1, Object arg2) {
        this.message("error", format, arg1, arg2);
    }

    default public void error(String format, Object ... arguments) {
        this.message("error", format, arguments);
    }

    default public void error(String msg, Throwable t) {
        this.message("error", msg, t);
    }

    default public void error(Marker marker, String msg) {
        this.error(msg);
    }

    default public void error(Marker marker, String format, Object arg) {
        this.error(format, arg);
    }

    default public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.error(format, arg1, arg2);
    }

    default public void error(Marker marker, String format, Object ... argArray) {
        this.error(format, argArray);
    }

    default public void error(Marker marker, String msg, Throwable t) {
        this.error(msg, t);
    }

    default public void fatal(String msg) {
        this.message("fatal", msg);
    }

    default public void fatal(String format, Object arg) {
        this.message("fatal", format, arg);
    }

    default public void fatal(String format, Object arg1, Object arg2) {
        this.message("fatal", format, arg1, arg2);
    }

    default public void fatal(String format, Object ... arguments) {
        this.message("fatal", format, arguments);
    }

    default public void fatal(String msg, Throwable t) {
        this.message("fatal", msg, t);
    }

    default public void fatal(Marker marker, String msg) {
        this.fatal(msg);
    }

    default public void fatal(Marker marker, String format, Object arg) {
        this.fatal(format, arg);
    }

    default public void fatal(Marker marker, String format, Object arg1, Object arg2) {
        this.fatal(format, arg1, arg2);
    }

    default public void fatal(Marker marker, String format, Object ... argArray) {
        this.fatal(format, argArray);
    }

    default public void fatal(Marker marker, String msg, Throwable t) {
        this.fatal(msg, t);
    }

    default public IMutableEvent trace() {
        if (this.isTraceEnabled()) {
            return this.topic("trace");
        }
        return NOPEvent.getSingleton();
    }

    default public IMutableEvent debug() {
        if (this.isDebugEnabled()) {
            return this.topic("debug");
        }
        return NOPEvent.getSingleton();
    }

    default public IMutableEvent info() {
        if (this.isInfoEnabled()) {
            return this.topic("info");
        }
        return NOPEvent.getSingleton();
    }

    default public IMutableEvent warn() {
        if (this.isWarnEnabled()) {
            return this.topic("warn");
        }
        return NOPEvent.getSingleton();
    }

    default public IMutableEvent error() {
        if (this.isErrorEnabled()) {
            return this.topic("error");
        }
        return NOPEvent.getSingleton();
    }

    default public IMutableEvent fatal() {
        if (this.isFatalEnabled()) {
            return this.topic("fatal");
        }
        return NOPEvent.getSingleton();
    }
}

