/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube;

import io.github.logtube.LogtubeOptionsProvider;
import io.github.logtube.utils.HttpIgnore;
import io.github.logtube.utils.Maps;
import io.github.logtube.utils.Strings;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class LogtubeOptions {
    private static final String CUSTOM_CONFIG_FILE_KEY = "logtube.config-file";
    private static final String CUSTOM_TOPICS_PREFIX = "logtube.topics.";
    @NotNull
    private final Properties properties;

    @NotNull
    public static String getHostname() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hostname == null) {
            hostname = "localhost";
        }
        return hostname;
    }

    @NotNull
    private static Set<String> quickStringSet(String ... values) {
        return new HashSet<String>(Arrays.asList(values));
    }

    @NotNull
    public static LogtubeOptions fromClasspath() {
        Properties properties = null;
        String customFile = System.getProperty(CUSTOM_CONFIG_FILE_KEY);
        if (customFile == null) {
            customFile = System.getenv(CUSTOM_CONFIG_FILE_KEY);
        }
        if (customFile != null) {
            properties = LogtubeOptions.propertiesFromFile(customFile);
        }
        if (properties == null) {
            properties = LogtubeOptions.propertiesFromFile("logtube.yml");
        }
        if (properties == null) {
            properties = LogtubeOptions.propertiesFromFile("logtube.yaml");
        }
        if (properties == null) {
            properties = LogtubeOptions.propertiesFromFile("logtube.properties");
        }
        if (properties == null) {
            properties = new Properties();
            System.err.println("logtube failed to load config file, using default configs");
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith("logtube.")) continue;
            properties.setProperty(key, entry.getValue());
        }
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith("logtube.")) continue;
            properties.setProperty(key, System.getProperty(key));
        }
        return new LogtubeOptions(properties);
    }

    @NotNull
    public static LogtubeOptions getDefault() {
        return new LogtubeOptions(new Properties());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static Properties propertiesFromFile(@NotNull String filename) {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(filename);){
            Properties properties = new Properties();
            if (stream != null) {
                Properties properties2;
                if (filename.toLowerCase().endsWith(".properties")) {
                    properties.load(stream);
                } else {
                    if (!filename.toLowerCase().endsWith(".yml") && !filename.toLowerCase().endsWith(".yaml")) {
                        System.err.println("unsupported file " + filename + ".");
                        Properties yml = null;
                        return yml;
                    }
                    Yaml yml = new Yaml();
                    Map map = (Map)yml.load(stream);
                    Maps.flattenProperties(properties, map);
                }
                String configFile = Strings.evaluateEnvironmentVariables(properties.getProperty(CUSTOM_CONFIG_FILE_KEY));
                if (configFile == null) {
                    properties2 = properties;
                    return properties2;
                }
                if (configFile.equalsIgnoreCase("APOLLO")) {
                    properties2 = LogtubeOptions.propertiesFromApollo();
                    return properties2;
                }
                properties2 = LogtubeOptions.propertiesFromFile(configFile);
                return properties2;
            }
            Properties properties3 = null;
            return properties3;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("failed to load " + filename + ".");
            return null;
        }
    }

    @Nullable
    private static Properties propertiesFromApollo() {
        return LogtubeOptions.propertiesFromProvider("io.github.logtube.apollo.LogtubeApolloOptionsProvider");
    }

    @Nullable
    private static Properties propertiesFromProvider(String className) {
        try {
            Class<?> providerClass = Class.forName(className);
            Object provider = providerClass.newInstance();
            if (provider instanceof LogtubeOptionsProvider) {
                return ((LogtubeOptionsProvider)provider).loadOptions();
            }
            return null;
        }
        catch (Throwable e) {
            System.err.println("Failed to load options provider: " + className + ": " + e.getMessage());
            return null;
        }
    }

    public LogtubeOptions(@NotNull Properties properties) {
        this.properties = properties;
    }

    @Nullable
    private String getProperty(@NotNull String field) {
        return Strings.evaluateEnvironmentVariables(this.properties.getProperty(field));
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    private String sanitizedStringValue(@NotNull String field, @Nullable String defaultValue) {
        return Strings.sanitize(this.getProperty(field), defaultValue);
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    private String stringValue(@NotNull String field, @Nullable String defaultValue) {
        String ret = this.getProperty(field);
        return ret == null ? defaultValue : ret;
    }

    private boolean booleanValue(String field, boolean defaultValue) {
        String value = this.getProperty(field);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).equalsIgnoreCase("true") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("yes")) {
            return true;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off") || value.equalsIgnoreCase("no")) {
            return false;
        }
        return defaultValue;
    }

    private int intValue(String field, int defaultValue) {
        String value = this.getProperty(field);
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        return Integer.valueOf(value.trim());
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private Set<String> setValue(String field, @Nullable Set<String> defaultValue) {
        String value = this.getProperty(field);
        if (value == null) {
            return defaultValue;
        }
        String[] components = value.split(",");
        if (components.length == 0) {
            return defaultValue;
        }
        HashSet<String> result = new HashSet<String>();
        for (String component : components) {
            if ((component = component.trim()).length() == 0) continue;
            result.add(component);
        }
        if (result.isEmpty()) {
            return defaultValue;
        }
        return result;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private Map<String, String> mapValue(String field, @Nullable Map<String, String> defaultValue) {
        String value = this.getProperty(field);
        if (value == null) {
            return defaultValue;
        }
        String[] components = value.split(",");
        if (components.length == 0) {
            return defaultValue;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String component : components) {
            String[] kvs;
            if ((component = component.trim()).length() == 0 || (kvs = component.split("=")).length != 2) continue;
            String k = Strings.normalize(kvs[0]);
            String v = Strings.normalize(kvs[1]);
            if (k == null || v == null) continue;
            result.put(k, v);
        }
        if (result.isEmpty()) {
            return defaultValue;
        }
        return result;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private String[] arrayValue(@NotNull String field, String[] defaultValue) {
        String value = this.getProperty(field);
        if (value == null) {
            return defaultValue;
        }
        String[] components = value.split(",");
        if (components.length == 0) {
            return defaultValue;
        }
        for (int i = 0; i < components.length; ++i) {
            components[i] = components[i].trim();
        }
        return components;
    }

    @NotNull
    public String getProject() {
        return this.sanitizedStringValue("logtube.project", "unknown-project");
    }

    @NotNull
    public String getEnv() {
        return this.sanitizedStringValue("logtube.env", "unknown-env");
    }

    @NotNull
    public Set<String> getTopics() {
        return this.setValue("logtube.topics.root", LogtubeOptions.quickStringSet("ALL", "-trace", "-debug"));
    }

    @NotNull
    public Map<String, Set<String>> getCustomTopics() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        this.properties.keySet().forEach(k -> {
            String key = k.toString();
            if (key.startsWith(CUSTOM_TOPICS_PREFIX)) {
                result.put(key.substring(CUSTOM_TOPICS_PREFIX.length()).toLowerCase(), this.setValue(key, new HashSet<String>()));
            }
        });
        return result;
    }

    @NotNull
    public Map<String, String> getTopicMappings() {
        return this.mapValue("logtube.topic-mappings", new HashMap<String, String>());
    }

    public boolean getConsoleEnabled() {
        return this.booleanValue("logtube.console.enabled", false);
    }

    @Nullable
    public Set<String> getConsoleTopics() {
        return this.setValue("logtube.console.topics", null);
    }

    @NotNull
    public String getRotationMode() {
        return this.stringValue("logtube.rotation.mode", "none");
    }

    public int getRotationKeep() {
        return this.intValue("logtube.rotation.keep", 0);
    }

    public boolean getFileEnabled() {
        return this.booleanValue("logtube.file.enabled", false);
    }

    @Nullable
    public Set<String> getFileTopics() {
        return this.setValue("logtube.file.topics", LogtubeOptions.quickStringSet("ALL"));
    }

    @NotNull
    public String getFileDir() {
        return this.stringValue("logtube.file.dir", "logs");
    }

    @NotNull
    public Map<String, String> getFileSubdirMappings() {
        return this.mapValue("logtube.file.subdir-mappings", new HashMap<String, String>());
    }

    @NotNull
    public String getFileSignal() {
        return this.stringValue("logtube.file.signal", "/tmp/logtube.reopen.txt");
    }

    public boolean getFilePlainEnabled() {
        return this.booleanValue("logtube.file-plain.enabled", false);
    }

    @Nullable
    public Set<String> getFilePlainTopics() {
        return this.setValue("logtube.file-plain.topics", LogtubeOptions.quickStringSet("trace", "debug", "info", "warn", "error"));
    }

    @NotNull
    public String getFilePlainDir() {
        return this.stringValue("logtube.file-plain.dir", "logs");
    }

    @NotNull
    public Map<String, String> getFilePlainSubdirMappings() {
        return this.mapValue("logtube.file-plain.subdir-mappings", new HashMap<String, String>());
    }

    @NotNull
    public String getFilePlainSignal() {
        return this.stringValue("logtube.file-plain.signal", "/tmp/logtube.reopen.txt");
    }

    public boolean getFileJSONEnabled() {
        return this.booleanValue("logtube.file-json.enabled", false);
    }

    @Nullable
    public Set<String> getFileJSONTopics() {
        return this.setValue("logtube.file-json.topics", LogtubeOptions.quickStringSet("ALL", "-trace", "-debug", "-info", "-warn", "-error"));
    }

    @NotNull
    public String getFileJSONDir() {
        return this.stringValue("logtube.file-json.dir", "logs");
    }

    @NotNull
    public Map<String, String> getFileJSONSubdirMappings() {
        return this.mapValue("logtube.file-json.subdir-mappings", new HashMap<String, String>());
    }

    @NotNull
    public String getFileJSONSignal() {
        return this.stringValue("logtube.file-json.signal", "/tmp/logtube.reopen.txt");
    }

    public boolean getRemoteEnabled() {
        return this.booleanValue("logtube.remote.enabled", false);
    }

    @Nullable
    public Set<String> getRemoteTopics() {
        return this.setValue("logtube.remote.topics", LogtubeOptions.quickStringSet("ALL", "-trace", "-debug"));
    }

    @NotNull
    public String[] getRemoteHosts() {
        return this.arrayValue("logtube.remote.hosts", new String[]{"127.0.0.1:9921"});
    }

    public boolean getRedisEnabled() {
        return this.booleanValue("logtube.redis.enabled", false);
    }

    @NotNull
    public Set<String> getRedisTopics() {
        return this.setValue("logtube.redis.topics", LogtubeOptions.quickStringSet("ALL", "-trace", "-debug"));
    }

    @NotNull
    public String[] getRedisHosts() {
        return this.arrayValue("logtube.redis.hosts", new String[]{"127.0.0.1"});
    }

    @NotNull
    public String getRedisKey() {
        return this.stringValue("logtube.redis.key", "logtube");
    }

    public HttpIgnore[] getHttpIgnores() {
        String[] raw = this.arrayValue("logtube.filter.http-ignores", new String[0]);
        ArrayList<HttpIgnore> ret = new ArrayList<HttpIgnore>();
        for (String s : raw) {
            String[] split = s.split(" ");
            if (split.length != 2) continue;
            ret.add(new HttpIgnore(split[0].trim(), split[1].trim()));
        }
        ret.add(new HttpIgnore("HEAD", "/"));
        ret.add(new HttpIgnore("GET", "/check"));
        ret.add(new HttpIgnore("GET", "/favicon.ico"));
        ret.add(new HttpIgnore("GET", "/actuator/health"));
        return ret.toArray(new HttpIgnore[0]);
    }

    public int getRedisMinDuration() {
        return this.intValue("logtube.filter.redis-min-duration", 0);
    }

    public int getRedisMinResultSize() {
        return this.intValue("logtube.filter.redis-min-result-size", 0);
    }
}

