/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube;

import io.github.logtube.LogtubeComponentConfigurator;
import io.github.logtube.LogtubeOptions;
import io.github.logtube.core.IEventLogger;
import io.github.logtube.core.IEventLoggerFactory;
import io.github.logtube.core.IEventProcessor;
import io.github.logtube.core.loggers.EventLogger;
import io.github.logtube.core.outputs.BaseEventOutput;
import io.github.logtube.core.outputs.EventConsoleOutput;
import io.github.logtube.core.outputs.EventFileOutput;
import io.github.logtube.core.outputs.EventJSONFileOutput;
import io.github.logtube.core.outputs.EventPlainFileOutput;
import io.github.logtube.core.outputs.EventRedisOutput;
import io.github.logtube.core.outputs.EventRemoteOutput;
import io.github.logtube.core.processors.EventProcessor;
import io.github.logtube.core.processors.NOPProcessor;
import io.github.logtube.utils.ITopicAware;
import io.github.logtube.utils.ITopicMutableAware;
import io.github.logtube.utils.LifeCycle;
import io.github.logtube.utils.Reloadable;
import io.github.logtube.utils.RotationThread;
import io.github.logtube.utils.TopicAware;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;

public class LogtubeLoggerFactory
extends LifeCycle
implements ILoggerFactory,
IEventLoggerFactory,
Reloadable {
    private static final LogtubeLoggerFactory SINGLETON = new LogtubeLoggerFactory();
    @NotNull
    private IEventProcessor processor = NOPProcessor.getSingleton();
    @NotNull
    private LogtubeOptions options = LogtubeOptions.getDefault();
    @NotNull
    private ITopicMutableAware rootTopics = new TopicAware();
    private Map<String, ITopicAware> customTopics = new HashMap<String, ITopicAware>();
    private final ConcurrentMap<String, IEventLogger> loggers = new ConcurrentHashMap<String, IEventLogger>();
    private RotationThread rotationThread = null;

    public static LogtubeLoggerFactory getSingleton() {
        return SINGLETON;
    }

    private LogtubeLoggerFactory() {
    }

    @Override
    @NotNull
    public ITopicAware getTopicAware(@NotNull String name) {
        ITopicMutableAware rootTopics = this.rootTopics;
        Map<String, ITopicAware> customTopics = this.customTopics;
        if (name.equals("ROOT")) {
            return rootTopics;
        }
        String found = null;
        ITopicAware topics = null;
        for (Map.Entry<String, ITopicAware> entry : customTopics.entrySet()) {
            String prefix = entry.getKey();
            ITopicAware value = entry.getValue();
            if (!name.toLowerCase().startsWith(prefix)) continue;
            if (found == null) {
                found = prefix;
                topics = value;
                continue;
            }
            if (prefix.length() <= found.length()) continue;
            found = prefix;
            topics = value;
        }
        if (topics == null) {
            return rootTopics;
        }
        return topics;
    }

    @Override
    @NotNull
    public IEventProcessor getProcessor() {
        return this.processor;
    }

    @NotNull
    public LogtubeOptions getOptions() {
        return this.options;
    }

    @NotNull
    public IEventLogger getEventLogger(@Nullable String name) {
        IEventLogger logger;
        if (name == null) {
            name = "ROOT";
        }
        if ((logger = (IEventLogger)this.loggers.get(name)) != null) {
            return logger;
        }
        EventLogger newInstance = new EventLogger(this, name);
        IEventLogger oldInstance = this.loggers.putIfAbsent(name, newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }

    public Logger getLogger(String name) {
        return this.getEventLogger(name);
    }

    private void swapProcessor(IEventProcessor newProcessor) {
        if (newProcessor == this.processor) {
            return;
        }
        newProcessor.start();
        IEventProcessor processor = this.processor;
        this.processor = newProcessor;
        processor.stop();
    }

    private void reloadLoggers() {
        this.loggers.forEach((name, l) -> {
            if (l instanceof Reloadable) {
                Reloadable r = (Reloadable)((Object)l);
                r.reload();
            }
        });
    }

    private void init() {
        BaseEventOutput output;
        TopicAware rootTopics = new TopicAware();
        HashMap<String, ITopicAware> customTopics = new HashMap<String, ITopicAware>();
        HashSet<String> logDirs = new HashSet<String>();
        HashSet<String> logSignals = new HashSet<String>();
        LogtubeOptions options = LogtubeOptions.fromClasspath();
        rootTopics.setTopics(options.getTopics());
        options.getCustomTopics().forEach((k, v) -> {
            TopicAware topicAware = new TopicAware();
            topicAware.setTopics((Set<String>)v);
            customTopics.put((String)k, topicAware);
        });
        EventProcessor processor = new EventProcessor();
        processor.setHostname(LogtubeOptions.getHostname());
        processor.setProject(options.getProject());
        processor.setEnv(options.getEnv());
        processor.setTopicMappings(options.getTopicMappings());
        if (options.getConsoleEnabled()) {
            output = new EventConsoleOutput();
            output.setTopics(options.getConsoleTopics());
            processor.addOutput(output);
        }
        if (options.getFileEnabled()) {
            output = new EventFileOutput(options.getFileDir(), options.getFileSubdirMappings(), options.getFileSignal());
            logDirs.add(options.getFileDir());
            logSignals.add(options.getFileSignal());
            output.setTopics(options.getFileTopics());
            processor.addOutput(output);
        } else {
            if (options.getFilePlainEnabled()) {
                output = new EventPlainFileOutput(options.getFilePlainDir(), options.getFilePlainSubdirMappings(), options.getFilePlainSignal());
                logDirs.add(options.getFilePlainDir());
                logSignals.add(options.getFilePlainSignal());
                output.setTopics(options.getFilePlainTopics());
                processor.addOutput(output);
            }
            if (options.getFileJSONEnabled()) {
                output = new EventJSONFileOutput(options.getFileJSONDir(), options.getFileJSONSubdirMappings(), options.getFileJSONSignal());
                logDirs.add(options.getFileJSONDir());
                logSignals.add(options.getFileJSONSignal());
                output.setTopics(options.getFileJSONTopics());
                processor.addOutput(output);
            }
        }
        if (options.getRemoteEnabled()) {
            output = new EventRemoteOutput(options.getRemoteHosts());
            output.setTopics(options.getRemoteTopics());
            processor.addOutput(output);
        }
        if (options.getRedisEnabled()) {
            output = new EventRedisOutput(options.getRedisHosts(), options.getRedisKey());
            output.setTopics(options.getRedisTopics());
            processor.addOutput(output);
        }
        this.configureComponent("io.github.logtube.redis.LogtubeJedisConfigurator", options);
        this.configureComponent("io.github.logtube.http.LogtubeHttpConfigurator", options);
        this.rootTopics = rootTopics;
        this.customTopics = customTopics;
        this.options = options;
        this.rotationThread.setup(options.getRotationMode(), options.getRotationKeep(), logDirs, logSignals, processor.getProject());
        this.swapProcessor(processor);
        this.reloadLoggers();
    }

    private void configureComponent(String className, LogtubeOptions options) {
        try {
            Class<?> clazz = Class.forName(className);
            Object object = clazz.newInstance();
            if (object instanceof LogtubeComponentConfigurator) {
                ((LogtubeComponentConfigurator)object).configure(options);
            }
        }
        catch (Throwable e) {
            System.err.println("Failed to load component: " + className + ": " + e.getMessage());
        }
    }

    @Override
    public synchronized void reload() {
        this.init();
        this.getEventLogger(null).topic("lifecycle").xLifecycle("logtube-reload").xLogtubeVersion("0.39.2").commit();
    }

    @Override
    public synchronized void doStart() {
        super.doStart();
        this.rotationThread = new RotationThread();
        this.rotationThread.setName("logtube-rotation");
        this.rotationThread.start();
        this.init();
        this.getEventLogger(null).topic("lifecycle").xLifecycle("boot").xLogtubeVersion("0.39.2").commit();
    }

    @Override
    public synchronized void doStop() {
        this.rotationThread.interrupt();
        this.rotationThread = null;
        this.rootTopics = new TopicAware();
        this.customTopics = new HashMap<String, ITopicAware>();
        this.options = LogtubeOptions.getDefault();
        this.swapProcessor(NOPProcessor.getSingleton());
        this.reloadLoggers();
        super.doStop();
    }

    static {
        SINGLETON.start();
    }
}

