/*
 * Decompiled with CFR 0.152.
 */
package io.github.logtube;

import io.github.logtube.LogtubeLoggerFactory;
import io.github.logtube.core.IEventContext;
import io.github.logtube.core.IEventLogger;
import io.github.logtube.core.IEventProcessor;
import io.github.logtube.core.IMutableEvent;
import io.github.logtube.utils.Reflections;
import io.github.logtube.utils.Strings;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;

public class Logtube {
    @NotNull
    public static IEventContext captureContext() {
        return Logtube.getProcessor().captureContext();
    }

    @NotNull
    public static IEventProcessor getProcessor() {
        return LogtubeLoggerFactory.getSingleton().getProcessor();
    }

    @NotNull
    public static IEventLogger getLogger(@NotNull String name) {
        return LogtubeLoggerFactory.getSingleton().getEventLogger(name);
    }

    @NotNull
    public static IEventLogger getLogger(@NotNull Class<?> clazz) {
        return Logtube.getLogger(clazz.getName());
    }

    @NotNull
    public static IEventLogger getLogger() {
        String className = "ROOT";
        StackTraceElement element = Reflections.getStackTraceElement();
        if (element != null) {
            className = element.getClassName();
        }
        return Logtube.getLogger(className);
    }

    @NotNull
    public static IMutableEvent topic(@NotNull String topic) {
        return Logtube.getLogger().topic(topic);
    }

    @NotNull
    public static IEventLogger keyword(Object ... keywords) {
        return Logtube.getLogger().keyword(keywords);
    }

    @Deprecated
    @NotNull
    public static IEventLogger withK(Object ... keywords) {
        return Logtube.keyword(keywords);
    }

    @Deprecated
    @NotNull
    public static String K(Object ... keywords) {
        return Strings.keyword(keywords);
    }

    public static void trace(String msg) {
        Logtube.getLogger().trace(msg);
    }

    public static void trace(String format, Object arg) {
        Logtube.getLogger().trace(format, arg);
    }

    public static void trace(String format, Object arg1, Object arg2) {
        Logtube.getLogger().trace(format, arg1, arg2);
    }

    public static void trace(String format, Object ... argArray) {
        Logtube.getLogger().trace(format, argArray);
    }

    public static void trace(String msg, Throwable t) {
        Logtube.getLogger().trace(msg, t);
    }

    public static void trace(Marker marker, String msg) {
        Logtube.getLogger().trace(marker, msg);
    }

    public static void trace(Marker marker, String format, Object arg) {
        Logtube.getLogger().trace(marker, format, arg);
    }

    public static void trace(Marker marker, String format, Object arg1, Object arg2) {
        Logtube.getLogger().trace(marker, format, arg1, arg2);
    }

    public static void trace(Marker marker, String format, Object ... argArray) {
        Logtube.getLogger().trace(marker, format, argArray);
    }

    public static void trace(Marker marker, String msg, Throwable t) {
        Logtube.getLogger().trace(marker, msg, t);
    }

    public static boolean isTraceEnabled() {
        return Logtube.getLogger().isTraceEnabled();
    }

    public static boolean isTraceEnabled(Marker marker) {
        return Logtube.getLogger().isTraceEnabled();
    }

    public static void debug(String msg) {
        Logtube.getLogger().debug(msg);
    }

    public static void debug(String format, Object arg) {
        Logtube.getLogger().debug(format, arg);
    }

    public static void debug(String format, Object arg1, Object arg2) {
        Logtube.getLogger().debug(format, arg1, arg2);
    }

    public static void debug(String format, Object ... argArray) {
        Logtube.getLogger().debug(format, argArray);
    }

    public static void debug(String msg, Throwable t) {
        Logtube.getLogger().debug(msg, t);
    }

    public static void debug(Marker marker, String msg) {
        Logtube.getLogger().debug(marker, msg);
    }

    public static void debug(Marker marker, String format, Object arg) {
        Logtube.getLogger().debug(marker, format, arg);
    }

    public static void debug(Marker marker, String format, Object arg1, Object arg2) {
        Logtube.getLogger().debug(marker, format, arg1, arg2);
    }

    public static void debug(Marker marker, String format, Object ... argArray) {
        Logtube.getLogger().debug(marker, format, argArray);
    }

    public static void debug(Marker marker, String msg, Throwable t) {
        Logtube.getLogger().debug(marker, msg, t);
    }

    public static boolean isDebugEnabled() {
        return Logtube.getLogger().isDebugEnabled();
    }

    public static boolean isDebugEnabled(Marker marker) {
        return Logtube.getLogger().isDebugEnabled();
    }

    public static void info(String msg) {
        Logtube.getLogger().info(msg);
    }

    public static void info(String format, Object arg) {
        Logtube.getLogger().info(format, arg);
    }

    public static void info(String format, Object arg1, Object arg2) {
        Logtube.getLogger().info(format, arg1, arg2);
    }

    public static void info(String format, Object ... argArray) {
        Logtube.getLogger().info(format, argArray);
    }

    public static void info(String msg, Throwable t) {
        Logtube.getLogger().info(msg, t);
    }

    public static void info(Marker marker, String msg) {
        Logtube.getLogger().info(marker, msg);
    }

    public static void info(Marker marker, String format, Object arg) {
        Logtube.getLogger().info(marker, format, arg);
    }

    public static void info(Marker marker, String format, Object arg1, Object arg2) {
        Logtube.getLogger().info(marker, format, arg1, arg2);
    }

    public static void info(Marker marker, String format, Object ... argArray) {
        Logtube.getLogger().info(marker, format, argArray);
    }

    public static void info(Marker marker, String msg, Throwable t) {
        Logtube.getLogger().info(marker, msg, t);
    }

    public static boolean isInfoEnabled() {
        return Logtube.getLogger().isInfoEnabled();
    }

    public static boolean isInfoEnabled(Marker marker) {
        return Logtube.getLogger().isInfoEnabled();
    }

    public static void warn(String msg) {
        Logtube.getLogger().warn(msg);
    }

    public static void warn(String format, Object arg) {
        Logtube.getLogger().warn(format, arg);
    }

    public static void warn(String format, Object arg1, Object arg2) {
        Logtube.getLogger().warn(format, arg1, arg2);
    }

    public static void warn(String format, Object ... argArray) {
        Logtube.getLogger().warn(format, argArray);
    }

    public static void warn(String msg, Throwable t) {
        Logtube.getLogger().warn(msg, t);
    }

    public static void warn(Marker marker, String msg) {
        Logtube.getLogger().warn(marker, msg);
    }

    public static void warn(Marker marker, String format, Object arg) {
        Logtube.getLogger().warn(marker, format, arg);
    }

    public static void warn(Marker marker, String format, Object arg1, Object arg2) {
        Logtube.getLogger().warn(marker, format, arg1, arg2);
    }

    public static void warn(Marker marker, String format, Object ... argArray) {
        Logtube.getLogger().warn(marker, format, argArray);
    }

    public static void warn(Marker marker, String msg, Throwable t) {
        Logtube.getLogger().warn(marker, msg, t);
    }

    public static boolean isWarnEnabled() {
        return Logtube.getLogger().isWarnEnabled();
    }

    public static boolean isWarnEnabled(Marker marker) {
        return Logtube.getLogger().isWarnEnabled();
    }

    public static void error(String msg) {
        Logtube.getLogger().error(msg);
    }

    public static void error(String format, Object arg) {
        Logtube.getLogger().error(format, arg);
    }

    public static void error(String format, Object arg1, Object arg2) {
        Logtube.getLogger().error(format, arg1, arg2);
    }

    public static void error(String format, Object ... argArray) {
        Logtube.getLogger().error(format, argArray);
    }

    public static void error(String msg, Throwable t) {
        Logtube.getLogger().error(msg, t);
    }

    public static void error(Marker marker, String msg) {
        Logtube.getLogger().error(marker, msg);
    }

    public static void error(Marker marker, String format, Object arg) {
        Logtube.getLogger().error(marker, format, arg);
    }

    public static void error(Marker marker, String format, Object arg1, Object arg2) {
        Logtube.getLogger().error(marker, format, arg1, arg2);
    }

    public static void error(Marker marker, String format, Object ... argArray) {
        Logtube.getLogger().error(marker, format, argArray);
    }

    public static void error(Marker marker, String msg, Throwable t) {
        Logtube.getLogger().error(marker, msg, t);
    }

    public static boolean isErrorEnabled() {
        return Logtube.getLogger().isErrorEnabled();
    }

    public static boolean isErrorEnabled(Marker marker) {
        return Logtube.getLogger().isErrorEnabled();
    }

    public static void fatal(String msg) {
        Logtube.getLogger().fatal(msg);
    }

    public static void fatal(String format, Object arg) {
        Logtube.getLogger().fatal(format, arg);
    }

    public static void fatal(String format, Object arg1, Object arg2) {
        Logtube.getLogger().fatal(format, arg1, arg2);
    }

    public static void fatal(String format, Object ... argArray) {
        Logtube.getLogger().fatal(format, argArray);
    }

    public static void fatal(String msg, Throwable t) {
        Logtube.getLogger().fatal(msg, t);
    }

    public static void fatal(Marker marker, String msg) {
        Logtube.getLogger().fatal(marker, msg);
    }

    public static void fatal(Marker marker, String format, Object arg) {
        Logtube.getLogger().fatal(marker, format, arg);
    }

    public static void fatal(Marker marker, String format, Object arg1, Object arg2) {
        Logtube.getLogger().fatal(marker, format, arg1, arg2);
    }

    public static void fatal(Marker marker, String format, Object ... argArray) {
        Logtube.getLogger().fatal(marker, format, argArray);
    }

    public static void fatal(Marker marker, String msg, Throwable t) {
        Logtube.getLogger().fatal(marker, msg, t);
    }

    public static boolean isFatalEnabled() {
        return Logtube.getLogger().isFatalEnabled();
    }

    public static boolean isFatalEnabled(Marker marker) {
        return Logtube.getLogger().isFatalEnabled();
    }

    public static IMutableEvent trace() {
        return Logtube.getLogger().trace();
    }

    public static IMutableEvent debug() {
        return Logtube.getLogger().debug();
    }

    public static IMutableEvent info() {
        return Logtube.getLogger().info();
    }

    public static IMutableEvent warn() {
        return Logtube.getLogger().warn();
    }

    public static IMutableEvent error() {
        return Logtube.getLogger().error();
    }

    public static IMutableEvent fatal() {
        return Logtube.getLogger().fatal();
    }
}

