package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface JobSpecFluent<A extends JobSpecFluent<A>> extends Fluent<A>{
  public Long getActiveDeadlineSeconds();
  public A withActiveDeadlineSeconds(Long activeDeadlineSeconds);
  public Boolean hasActiveDeadlineSeconds();
  public Integer getBackoffLimit();
  public A withBackoffLimit(Integer backoffLimit);
  public Boolean hasBackoffLimit();
  public String getCompletionMode();
  public A withCompletionMode(String completionMode);
  public Boolean hasCompletionMode();
  public Integer getCompletions();
  public A withCompletions(Integer completions);
  public Boolean hasCompletions();
  public Boolean getManualSelector();
  public A withManualSelector(Boolean manualSelector);
  public Boolean hasManualSelector();
  public Integer getParallelism();
  public A withParallelism(Integer parallelism);
  public Boolean hasParallelism();
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector();
  public LabelSelector buildSelector();
  public A withSelector(LabelSelector selector);
  public Boolean hasSelector();
  public JobSpecFluent.SelectorNested<A> withNewSelector();
  public JobSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
  public JobSpecFluent.SelectorNested<A> editSelector();
  public JobSpecFluent.SelectorNested<A> editOrNewSelector();
  public JobSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
  public Boolean getSuspend();
  public A withSuspend(Boolean suspend);
  public Boolean hasSuspend();
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodTemplateSpec getTemplate();
  public PodTemplateSpec buildTemplate();
  public A withTemplate(PodTemplateSpec template);
  public Boolean hasTemplate();
  public JobSpecFluent.TemplateNested<A> withNewTemplate();
  public JobSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
  public JobSpecFluent.TemplateNested<A> editTemplate();
  public JobSpecFluent.TemplateNested<A> editOrNewTemplate();
  public JobSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
  public Integer getTtlSecondsAfterFinished();
  public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished);
  public Boolean hasTtlSecondsAfterFinished();
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public A withManualSelector();
  public A withSuspend();
  public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<JobSpecFluent.SelectorNested<N>>{
    public N and();
    public N endSelector();
    
  }
  public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<JobSpecFluent.TemplateNested<N>>{
    public N and();
    public N endTemplate();
    
  }
  
}