package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CronJobListBuilder extends CronJobListFluentImpl<CronJobListBuilder> implements VisitableBuilder<CronJobList,CronJobListBuilder>{
  public CronJobListBuilder() {
    this(false);
  }
  public CronJobListBuilder(Boolean validationEnabled) {
    this(new CronJobList(), validationEnabled);
  }
  public CronJobListBuilder(CronJobListFluent<?> fluent) {
    this(fluent, false);
  }
  public CronJobListBuilder(CronJobListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CronJobList(), validationEnabled);
  }
  public CronJobListBuilder(CronJobListFluent<?> fluent,CronJobList instance) {
    this(fluent, instance, false);
  }
  public CronJobListBuilder(CronJobListFluent<?> fluent,CronJobList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CronJobListBuilder(CronJobList instance) {
    this(instance,false);
  }
  public CronJobListBuilder(CronJobList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CronJobListFluent<?> fluent;
  Boolean validationEnabled;
  public CronJobList build() {
    CronJobList buildable = new CronJobList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}