/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.Show;
import cats.Show$;
import cats.kernel.Eq;
import cats.package$;
import io.circe.Json;
import io.circe.Json$JNull$;
import io.circe.JsonBigDecimal;
import io.circe.JsonBiggerDecimal;
import io.circe.JsonDouble;
import io.circe.JsonFloat;
import io.circe.JsonLong;
import io.circe.JsonNumber;
import io.circe.JsonNumber$;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.numbers.BiggerDecimal$;
import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;

public final class Json$
implements scala.Serializable {
    public static Json$ MODULE$;
    private final Json Null;
    private final Json True;
    private final Json False;
    private final Eq<Json> eqJson;
    private final Show<Json> showJson;

    static {
        new Json$();
    }

    public final Json Null() {
        return this.Null;
    }

    public final Json True() {
        return this.True;
    }

    public final Json False() {
        return this.False;
    }

    public final Json obj(Seq<Tuple2<String, Json>> fields) {
        return this.fromFields((Iterable<Tuple2<String, Json>>)fields);
    }

    public final Json arr(Seq<Json> values) {
        return this.fromValues((Iterable<Json>)values);
    }

    public final Json fromFields(Iterable<Tuple2<String, Json>> fields) {
        return new Json.JObject(JsonObject$.MODULE$.fromIterable(fields));
    }

    public final Json fromValues(Iterable<Json> values) {
        return new Json.JArray((Vector<Json>)values.toVector());
    }

    public final Json fromJsonObject(JsonObject value) {
        return new Json.JObject(value);
    }

    public final Json fromJsonNumber(JsonNumber value) {
        return new Json.JNumber(value);
    }

    public final Json fromString(String value) {
        return new Json.JString(value);
    }

    public final Json fromBoolean(boolean value) {
        return value ? this.True() : this.False();
    }

    public final Json fromInt(int value) {
        return new Json.JNumber(new JsonLong(value));
    }

    public final Json fromLong(long value) {
        return new Json.JNumber(new JsonLong(value));
    }

    public final Option<Json> fromDouble(double value) {
        return this.isReal(value) ? new Some((Object)new Json.JNumber(new JsonDouble(value))) : None$.MODULE$;
    }

    public final Option<Json> fromFloat(float value) {
        return this.isReal(value) ? new Some((Object)new Json.JNumber(new JsonFloat(value))) : None$.MODULE$;
    }

    public final Json fromDoubleOrNull(double value) {
        return this.isReal(value) ? new Json.JNumber(new JsonDouble(value)) : this.Null();
    }

    public final Json fromFloatOrNull(float value) {
        return this.isReal(value) ? new Json.JNumber(new JsonFloat(value)) : this.Null();
    }

    public final Json fromDoubleOrString(double value) {
        return this.isReal(value) ? new Json.JNumber(new JsonDouble(value)) : this.fromString(Double.toString(value));
    }

    public final Json fromFloatOrString(float value) {
        return this.isReal(value) ? new Json.JNumber(new JsonFloat(value)) : this.fromString(Float.toString(value));
    }

    public final Json fromBigInt(BigInt value) {
        return new Json.JNumber(new JsonBiggerDecimal(BiggerDecimal$.MODULE$.fromBigInteger(value.underlying())));
    }

    public final Json fromBigDecimal(BigDecimal value) {
        return new Json.JNumber(new JsonBigDecimal(value));
    }

    private boolean isReal(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    private boolean isReal(float value) {
        return !Float.isNaN(value) && !Float.isInfinite(value);
    }

    private final boolean arrayEq(Seq<Json> x, Seq<Json> y) {
        Iterator it0 = x.iterator();
        Iterator it1 = y.iterator();
        while (it0.hasNext() && it1.hasNext()) {
            if (!this.eqJson().neqv(it0.next(), it1.next())) continue;
            return false;
        }
        return it0.hasNext() == it1.hasNext();
    }

    public final Eq<Json> eqJson() {
        return this.eqJson;
    }

    public final Show<Json> showJson() {
        return this.showJson;
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$eqJson$1(Json$ $this, Json x0$3, Json x1$2) {
        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$2);
        if (tuple2 != null) {
            Json json = (Json)tuple2._1();
            Json json2 = (Json)tuple2._2();
            if (json instanceof Json.JObject) {
                Json.JObject jObject = (Json.JObject)json;
                JsonObject a = jObject.o();
                if (json2 instanceof Json.JObject) {
                    Json.JObject jObject2 = (Json.JObject)json2;
                    JsonObject b = jObject2.o();
                    return JsonObject$.MODULE$.eqJsonObject().eqv((Object)a, (Object)b);
                }
            }
        }
        if (tuple2 != null) {
            Json json = (Json)tuple2._1();
            Json json3 = (Json)tuple2._2();
            if (json instanceof Json.JString) {
                Json.JString jString = (Json.JString)json;
                String a = jString.s();
                if (json3 instanceof Json.JString) {
                    Json.JString jString2 = (Json.JString)json3;
                    String b = jString2.s();
                    String string = a;
                    String string2 = b;
                    if (string != null) {
                        if (!string.equals(string2)) return false;
                        return true;
                    }
                    if (string2 == null) return true;
                    return false;
                }
            }
        }
        if (tuple2 != null) {
            Json json = (Json)tuple2._1();
            Json json4 = (Json)tuple2._2();
            if (json instanceof Json.JNumber) {
                Json.JNumber jNumber = (Json.JNumber)json;
                JsonNumber a = jNumber.n();
                if (json4 instanceof Json.JNumber) {
                    Json.JNumber jNumber2 = (Json.JNumber)json4;
                    JsonNumber b = jNumber2.n();
                    return JsonNumber$.MODULE$.eqJsonNumber().eqv((Object)a, (Object)b);
                }
            }
        }
        if (tuple2 != null) {
            Json json = (Json)tuple2._1();
            Json json5 = (Json)tuple2._2();
            if (json instanceof Json.JBoolean) {
                Json.JBoolean jBoolean = (Json.JBoolean)json;
                boolean a = jBoolean.b();
                if (json5 instanceof Json.JBoolean) {
                    Json.JBoolean jBoolean2 = (Json.JBoolean)json5;
                    boolean b = jBoolean2.b();
                    if (a != b) return false;
                    return true;
                }
            }
        }
        if (tuple2 != null) {
            Json json = (Json)tuple2._1();
            Json json6 = (Json)tuple2._2();
            if (json instanceof Json.JArray) {
                Json.JArray jArray = (Json.JArray)json;
                Vector<Json> a = jArray.a();
                if (json6 instanceof Json.JArray) {
                    Json.JArray jArray2 = (Json.JArray)json6;
                    Vector<Json> b = jArray2.a();
                    return $this.arrayEq((Seq<Json>)a, (Seq<Json>)b);
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Json x = (Json)tuple2._1();
        Json y = (Json)tuple2._2();
        if (!x.isNull()) return false;
        if (!y.isNull()) return false;
        return true;
    }

    private Json$() {
        MODULE$ = this;
        this.Null = Json$JNull$.MODULE$;
        this.True = new Json.JBoolean(true);
        this.False = new Json.JBoolean(false);
        this.eqJson = package$.MODULE$.Eq().instance((Function2 & Serializable & scala.Serializable)(x0$3, x1$2) -> BoxesRunTime.boxToBoolean((boolean)Json$.$anonfun$eqJson$1(this, x0$3, x1$2)));
        this.showJson = Show$.MODULE$.fromToString();
    }
}

