/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.runtime.Runtime;
import java.io.PrintStream;
import java.util.List;

public class SummaryPrinter {
    private final PrintStream out;

    public SummaryPrinter(PrintStream out) {
        this.out = out;
    }

    public void print(Runtime runtime) {
        this.out.println();
        this.printStats(runtime);
        this.out.println();
        this.printErrors(runtime);
        this.printSnippets(runtime);
    }

    private void printStats(Runtime runtime) {
        runtime.printStats(this.out);
    }

    private void printErrors(Runtime runtime) {
        for (Throwable error : runtime.getErrors()) {
            error.printStackTrace(this.out);
            this.out.println();
        }
    }

    private void printSnippets(Runtime runtime) {
        List<String> snippets = runtime.getSnippets();
        if (!snippets.isEmpty()) {
            this.out.append("\n");
            this.out.println("You can implement missing steps with the snippets below:");
            this.out.println();
            for (String snippet : snippets) {
                this.out.println(snippet);
            }
        }
    }
}

