/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationOutput;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationOutput;
import com.alibaba.dashscope.aigc.multimodalconversation.MultiModalConversationResult;
import com.alibaba.dashscope.common.Message;
import com.alibaba.dashscope.common.MultiModalMessage;
import com.alibaba.dashscope.common.Role;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;

class QwenHelper {
    QwenHelper() {
    }

    static List<Message> toQwenMessages(List<ChatMessage> messages) {
        return messages.stream().map(QwenHelper::toQwenMessage).collect(Collectors.toList());
    }

    static List<Message> toQwenMessages(Iterable<ChatMessage> messages) {
        LinkedList<Message> qwenMessages = new LinkedList<Message>();
        messages.forEach(message -> qwenMessages.add(QwenHelper.toQwenMessage(message)));
        return qwenMessages;
    }

    static Message toQwenMessage(ChatMessage message) {
        return Message.builder().role(QwenHelper.roleFrom(message)).content(QwenHelper.toSingleText(message)).build();
    }

    static String toSingleText(ChatMessage message) {
        switch (message.type()) {
            case USER: {
                return ((UserMessage)message).contents().stream().filter(TextContent.class::isInstance).map(TextContent.class::cast).map(TextContent::text).collect(Collectors.joining("\n"));
            }
            case AI: {
                return ((AiMessage)message).text();
            }
            case SYSTEM: {
                return ((SystemMessage)message).text();
            }
            case TOOL_EXECUTION_RESULT: {
                return ((ToolExecutionResultMessage)message).text();
            }
        }
        return "";
    }

    static List<MultiModalMessage> toQwenMultiModalMessages(List<ChatMessage> messages) {
        return messages.stream().map(QwenHelper::toQwenMultiModalMessage).collect(Collectors.toList());
    }

    static MultiModalMessage toQwenMultiModalMessage(ChatMessage message) {
        return MultiModalMessage.builder().role(QwenHelper.roleFrom(message)).content(QwenHelper.toMultiModalContents(message)).build();
    }

    static List<Map<String, Object>> toMultiModalContents(ChatMessage message) {
        switch (message.type()) {
            case USER: {
                return ((UserMessage)message).contents().stream().map(QwenHelper::toMultiModalContent).collect(Collectors.toList());
            }
            case AI: {
                return Collections.singletonList(Collections.singletonMap("text", ((AiMessage)message).text()));
            }
            case SYSTEM: {
                return Collections.singletonList(Collections.singletonMap("text", ((SystemMessage)message).text()));
            }
            case TOOL_EXECUTION_RESULT: {
                return Collections.singletonList(Collections.singletonMap("text", ((ToolExecutionResultMessage)message).text()));
            }
        }
        return Collections.emptyList();
    }

    static Map<String, Object> toMultiModalContent(Content content) {
        switch (content.type()) {
            case IMAGE: {
                Image image = ((ImageContent)content).image();
                if (image.url() != null) {
                    String imageContent = image.url().toString();
                    return Collections.singletonMap("image", imageContent);
                }
                if (Utils.isNotNullOrBlank((String)image.base64Data())) {
                    String imageContent = QwenHelper.saveImageAsTemporaryFile(image.base64Data(), image.mimeType());
                    HashMap<String, Object> contentMap = new HashMap<String, Object>(1);
                    contentMap.put("image", imageContent);
                    return contentMap;
                }
                return Collections.emptyMap();
            }
            case TEXT: {
                return Collections.singletonMap("text", ((TextContent)content).text());
            }
        }
        return Collections.emptyMap();
    }

    private static String saveImageAsTemporaryFile(String base64Data, String mimeType) {
        int lastSlashIndex;
        String tmpDir = System.getProperty("java.io.tmpdir", "/tmp");
        String tmpImageName = UUID.randomUUID().toString();
        if (Utils.isNotNullOrBlank((String)mimeType) && (lastSlashIndex = mimeType.lastIndexOf("/")) >= 0 && lastSlashIndex < mimeType.length() - 1) {
            String imageSuffix = mimeType.substring(lastSlashIndex + 1);
            tmpImageName = tmpImageName + "." + imageSuffix;
        }
        Path tmpImagePath = Paths.get(tmpDir, tmpImageName);
        byte[] data = Base64.getDecoder().decode(base64Data);
        try {
            Files.copy(new ByteArrayInputStream(data), tmpImagePath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return tmpImagePath.toAbsolutePath().toUri().toString();
    }

    static String roleFrom(ChatMessage message) {
        if (message instanceof AiMessage) {
            return Role.ASSISTANT.getValue();
        }
        if (message instanceof SystemMessage) {
            return Role.SYSTEM.getValue();
        }
        return Role.USER.getValue();
    }

    static boolean hasAnswer(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).isPresent();
    }

    static String answerFrom(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getMessage).map(Message::getContent).orElseGet(() -> Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getText).orElseThrow(NullPointerException::new));
    }

    static boolean hasAnswer(MultiModalConversationResult result) {
        return Optional.of(result).map(MultiModalConversationResult::getOutput).map(MultiModalConversationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (MultiModalConversationOutput.Choice)choices.get(0)).map(MultiModalConversationOutput.Choice::getMessage).map(MultiModalMessage::getContent).filter(contents -> !contents.isEmpty()).isPresent();
    }

    static String answerFrom(MultiModalConversationResult result) {
        return Optional.of(result).map(MultiModalConversationResult::getOutput).map(MultiModalConversationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (MultiModalConversationOutput.Choice)choices.get(0)).map(MultiModalConversationOutput.Choice::getMessage).map(MultiModalMessage::getContent).filter(contents -> !contents.isEmpty()).map(contents -> (Map)contents.get(0)).map(content -> content.get("text")).map(String.class::cast).orElseThrow(NullPointerException::new);
    }

    static TokenUsage tokenUsageFrom(GenerationResult result) {
        return Optional.of(result).map(GenerationResult::getUsage).map(usage -> new TokenUsage(usage.getInputTokens(), usage.getOutputTokens())).orElse(null);
    }

    static TokenUsage tokenUsageFrom(MultiModalConversationResult result) {
        return Optional.of(result).map(MultiModalConversationResult::getUsage).map(usage -> new TokenUsage(usage.getInputTokens(), usage.getOutputTokens())).orElse(null);
    }

    static FinishReason finishReasonFrom(GenerationResult result) {
        String finishReason;
        switch (finishReason = Optional.of(result).map(GenerationResult::getOutput).map(GenerationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (GenerationOutput.Choice)choices.get(0)).map(GenerationOutput.Choice::getFinishReason).orElse("")) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
        }
        return null;
    }

    static FinishReason finishReasonFrom(MultiModalConversationResult result) {
        String finishReason;
        switch (finishReason = Optional.of(result).map(MultiModalConversationResult::getOutput).map(MultiModalConversationOutput::getChoices).filter(choices -> !choices.isEmpty()).map(choices -> (MultiModalConversationOutput.Choice)choices.get(0)).map(MultiModalConversationOutput.Choice::getFinishReason).orElse("")) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
        }
        return null;
    }

    public static boolean isMultimodalModel(String modelName) {
        return modelName.startsWith("qwen-vl");
    }
}

