/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.models.QwenParam;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.common.ResultCallback;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.dashscope.QwenLanguageModel;
import dev.langchain4j.model.dashscope.QwenStreamingResponseBuilder;
import dev.langchain4j.model.language.StreamingLanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;

public class QwenStreamingLanguageModel
extends QwenLanguageModel
implements StreamingLanguageModel {
    public QwenStreamingLanguageModel(String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed) {
        super(apiKey, modelName, topP, topK, enableSearch, seed);
    }

    public void generate(String prompt, final StreamingResponseHandler<String> handler) {
        try {
            QwenParam param = ((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)QwenParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).prompt(prompt)).resultFormat(QwenParam.ResultFormat.MESSAGE).build();
            final QwenStreamingResponseBuilder responseBuilder = new QwenStreamingResponseBuilder();
            this.generation.streamCall((HalfDuplexServiceParam)param, (ResultCallback)new ResultCallback<GenerationResult>(){

                public void onEvent(GenerationResult result) {
                    String delta = responseBuilder.append(result);
                    if (delta != null) {
                        handler.onNext(delta);
                    }
                }

                public void onComplete() {
                    Response<AiMessage> response = responseBuilder.build();
                    handler.onComplete(Response.from((Object)((AiMessage)response.content()).text(), (TokenUsage)response.tokenUsage(), (FinishReason)response.finishReason()));
                }

                public void onError(Exception e) {
                    handler.onError((Throwable)e);
                }
            });
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends QwenLanguageModel.Builder {
        @Override
        public Builder apiKey(String apiKey) {
            return (Builder)super.apiKey(apiKey);
        }

        @Override
        public Builder modelName(String modelName) {
            return (Builder)super.modelName(modelName);
        }

        @Override
        public Builder topP(Double topP) {
            return (Builder)super.topP(topP);
        }

        @Override
        public Builder topK(Integer topK) {
            return (Builder)super.topK(topK);
        }

        @Override
        public Builder enableSearch(Boolean enableSearch) {
            return (Builder)super.enableSearch(enableSearch);
        }

        @Override
        public Builder seed(Integer seed) {
            return (Builder)super.seed(seed);
        }

        @Override
        public QwenStreamingLanguageModel build() {
            this.ensureOptions();
            return new QwenStreamingLanguageModel(this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed);
        }
    }
}

