/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.dashscope;

import com.alibaba.dashscope.aigc.generation.Generation;
import com.alibaba.dashscope.aigc.generation.GenerationResult;
import com.alibaba.dashscope.aigc.generation.models.QwenParam;
import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.exception.NoApiKeyException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.dashscope.QwenHelper;
import dev.langchain4j.model.language.LanguageModel;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;

public class QwenLanguageModel
implements LanguageModel {
    protected final String apiKey;
    protected final String modelName;
    protected final Double topP;
    protected final Integer topK;
    protected final Boolean enableSearch;
    protected final Integer seed;
    protected final Generation generation;

    public QwenLanguageModel(String apiKey, String modelName, Double topP, Integer topK, Boolean enableSearch, Integer seed) {
        this.apiKey = apiKey;
        this.modelName = modelName;
        this.topP = topP;
        this.topK = topK;
        this.enableSearch = enableSearch;
        this.seed = seed;
        this.generation = new Generation();
    }

    public Response<String> generate(String prompt) {
        try {
            QwenParam param = ((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)((QwenParam.QwenParamBuilder)QwenParam.builder().apiKey(this.apiKey)).model(this.modelName)).topP(this.topP).topK(this.topK).enableSearch(this.enableSearch).seed(this.seed).prompt(prompt)).resultFormat(QwenParam.ResultFormat.MESSAGE).build();
            GenerationResult generationResult = this.generation.call((HalfDuplexServiceParam)param);
            return Response.from((Object)QwenHelper.answerFrom(generationResult), (TokenUsage)QwenHelper.tokenUsageFrom(generationResult), (FinishReason)QwenHelper.finishReasonFrom(generationResult));
        }
        catch (InputRequiredException | NoApiKeyException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        protected String apiKey;
        protected String modelName;
        protected Double topP;
        protected Integer topK;
        protected Boolean enableSearch;
        protected Integer seed;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder topP(Double topP) {
            this.topP = topP;
            return this;
        }

        public Builder topK(Integer topK) {
            this.topK = topK;
            return this;
        }

        public Builder enableSearch(Boolean enableSearch) {
            this.enableSearch = enableSearch;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        protected void ensureOptions() {
            if (Utils.isNullOrBlank((String)this.apiKey)) {
                throw new IllegalArgumentException("DashScope api key must be defined. It can be generated here: https://dashscope.console.aliyun.com/apiKey");
            }
            this.modelName = Utils.isNullOrBlank((String)this.modelName) ? "qwen-plus" : this.modelName;
            this.enableSearch = this.enableSearch != null && this.enableSearch != false;
        }

        public QwenLanguageModel build() {
            this.ensureOptions();
            return new QwenLanguageModel(this.apiKey, this.modelName, this.topP, this.topK, this.enableSearch, this.seed);
        }
    }
}

