/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.Internal;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.tool.ToolExecution;
import java.util.List;
import java.util.Objects;

@Internal
public class ToolServiceResult {
    private final List<ChatResponse> intermediateResponses;
    private final ChatResponse finalResponse;
    private final List<ToolExecution> toolExecutions;
    private final TokenUsage aggregateTokenUsage;

    public ToolServiceResult(Builder builder) {
        this.intermediateResponses = Utils.copy(builder.intermediateResponses);
        this.finalResponse = (ChatResponse)ValidationUtils.ensureNotNull((Object)builder.finalResponse, (String)"finalResponse");
        this.toolExecutions = (List)ValidationUtils.ensureNotNull(builder.toolExecutions, (String)"toolExecutions");
        this.aggregateTokenUsage = builder.aggregateTokenUsage;
    }

    @Deprecated(since="1.2.0")
    public ToolServiceResult(ChatResponse chatResponse, List<ToolExecution> toolExecutions) {
        this.intermediateResponses = List.of();
        this.finalResponse = (ChatResponse)ValidationUtils.ensureNotNull((Object)chatResponse, (String)"chatResponse");
        this.toolExecutions = (List)ValidationUtils.ensureNotNull(toolExecutions, (String)"toolExecutions");
        this.aggregateTokenUsage = chatResponse.tokenUsage();
    }

    public List<ChatResponse> intermediateResponses() {
        return this.intermediateResponses;
    }

    public ChatResponse finalResponse() {
        return this.finalResponse;
    }

    public ChatResponse aggregateResponse() {
        return ChatResponse.builder().aiMessage(this.finalResponse.aiMessage()).metadata(this.finalResponse.metadata().toBuilder().tokenUsage(this.aggregateTokenUsage).build()).build();
    }

    @Deprecated(since="1.2.0")
    public ChatResponse chatResponse() {
        return this.aggregateResponse();
    }

    public List<ToolExecution> toolExecutions() {
        return this.toolExecutions;
    }

    public TokenUsage aggregateTokenUsage() {
        return this.aggregateTokenUsage;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ToolServiceResult that = (ToolServiceResult)obj;
        return Objects.equals(this.intermediateResponses, that.intermediateResponses) && Objects.equals(this.finalResponse, that.finalResponse) && Objects.equals(this.toolExecutions, that.toolExecutions) && Objects.equals(this.aggregateTokenUsage, that.aggregateTokenUsage);
    }

    public int hashCode() {
        return Objects.hash(this.intermediateResponses, this.finalResponse, this.toolExecutions, this.aggregateTokenUsage);
    }

    public String toString() {
        return "ToolServiceResult{intermediateResponses=" + String.valueOf(this.intermediateResponses) + ", finalResponse=" + String.valueOf(this.finalResponse) + ", toolExecutions=" + String.valueOf(this.toolExecutions) + ", aggregateTokenUsage=" + String.valueOf(this.aggregateTokenUsage) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<ChatResponse> intermediateResponses;
        private ChatResponse finalResponse;
        private List<ToolExecution> toolExecutions;
        private TokenUsage aggregateTokenUsage;

        public Builder intermediateResponses(List<ChatResponse> intermediateResponses) {
            this.intermediateResponses = intermediateResponses;
            return this;
        }

        public Builder finalResponse(ChatResponse finalResponse) {
            this.finalResponse = finalResponse;
            return this;
        }

        public Builder toolExecutions(List<ToolExecution> toolExecutions) {
            this.toolExecutions = toolExecutions;
            return this;
        }

        public Builder aggregateTokenUsage(TokenUsage aggregateTokenUsage) {
            this.aggregateTokenUsage = aggregateTokenUsage;
            return this;
        }

        public ToolServiceResult build() {
            return new ToolServiceResult(this);
        }
    }
}

