/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service.tool;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.IllegalConfigurationException;
import dev.langchain4j.service.tool.DefaultToolExecutor;
import dev.langchain4j.service.tool.HallucinatedToolNameStrategy;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolProvider;
import dev.langchain4j.service.tool.ToolProviderRequest;
import dev.langchain4j.service.tool.ToolProviderResult;
import dev.langchain4j.service.tool.ToolServiceContext;
import dev.langchain4j.service.tool.ToolServiceResult;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@Internal
public class ToolService {
    private final List<ToolSpecification> toolSpecifications = new ArrayList<ToolSpecification>();
    private final Map<String, ToolExecutor> toolExecutors = new HashMap<String, ToolExecutor>();
    private ToolProvider toolProvider;
    private int maxSequentialToolsInvocations = 100;
    private Function<ToolExecutionRequest, ToolExecutionResultMessage> toolHallucinationStrategy = HallucinatedToolNameStrategy.THROW_EXCEPTION;

    public void hallucinatedToolNameStrategy(Function<ToolExecutionRequest, ToolExecutionResultMessage> toolHallucinationStrategy) {
        this.toolHallucinationStrategy = toolHallucinationStrategy;
    }

    public void toolProvider(ToolProvider toolProvider) {
        this.toolProvider = toolProvider;
    }

    public void tools(Map<ToolSpecification, ToolExecutor> tools) {
        tools.forEach((toolSpecification, toolExecutor) -> {
            this.toolSpecifications.add((ToolSpecification)toolSpecification);
            this.toolExecutors.put(toolSpecification.name(), (ToolExecutor)toolExecutor);
        });
    }

    public void tools(Collection<Object> objectsWithTools) {
        for (Object objectWithTool : objectsWithTools) {
            if (objectWithTool instanceof Class) {
                throw IllegalConfigurationException.illegalConfiguration("Tool '%s' must be an object, not a class", objectWithTool);
            }
            for (Method method : objectWithTool.getClass().getDeclaredMethods()) {
                Utils.getAnnotatedMethod((Method)method, Tool.class).ifPresent(toolMethod -> this.processToolMethod(objectWithTool, (Method)toolMethod));
            }
        }
    }

    private void processToolMethod(Object objectWithTool, Method method) {
        ToolSpecification toolSpecification = ToolSpecifications.toolSpecificationFrom((Method)method);
        if (this.toolExecutors.containsKey(toolSpecification.name())) {
            throw new IllegalConfigurationException("Duplicated definition for tool: " + toolSpecification.name());
        }
        this.toolExecutors.put(toolSpecification.name(), new DefaultToolExecutor(objectWithTool, method));
        this.toolSpecifications.add(ToolSpecifications.toolSpecificationFrom((Method)method));
    }

    public void maxSequentialToolsInvocations(int maxSequentialToolsInvocations) {
        this.maxSequentialToolsInvocations = maxSequentialToolsInvocations;
    }

    public ToolServiceContext createContext(Object memoryId, UserMessage userMessage) {
        if (this.toolProvider == null) {
            return this.toolSpecifications.isEmpty() ? new ToolServiceContext(null, null) : new ToolServiceContext(this.toolSpecifications, this.toolExecutors);
        }
        ArrayList<ToolSpecification> toolsSpecs = new ArrayList<ToolSpecification>(this.toolSpecifications);
        HashMap<String, ToolExecutor> toolExecs = new HashMap<String, ToolExecutor>(this.toolExecutors);
        ToolProviderRequest toolProviderRequest = new ToolProviderRequest(memoryId, userMessage);
        ToolProviderResult toolProviderResult = this.toolProvider.provideTools(toolProviderRequest);
        if (toolProviderResult != null) {
            for (Map.Entry<ToolSpecification, ToolExecutor> entry : toolProviderResult.tools().entrySet()) {
                if (toolExecs.putIfAbsent(entry.getKey().name(), entry.getValue()) == null) {
                    toolsSpecs.add(entry.getKey());
                    continue;
                }
                throw new IllegalConfigurationException("Duplicated definition for tool: " + entry.getKey().name());
            }
        }
        return new ToolServiceContext(toolsSpecs, toolExecs);
    }

    public ToolServiceResult executeInferenceAndToolsLoop(ChatResponse chatResponse, ChatRequestParameters parameters, List<ChatMessage> messages, ChatModel chatModel, ChatMemory chatMemory, Object memoryId, Map<String, ToolExecutor> toolExecutors) {
        TokenUsage aggregateTokenUsage = chatResponse.metadata().tokenUsage();
        ArrayList<ToolExecution> toolExecutions = new ArrayList<ToolExecution>();
        ArrayList<ChatResponse> intermediateResponses = new ArrayList<ChatResponse>();
        int executionsLeft = this.maxSequentialToolsInvocations;
        while (true) {
            if (executionsLeft-- == 0) {
                throw Exceptions.runtime((String)"Something is wrong, exceeded %s sequential tool executions", (Object[])new Object[]{this.maxSequentialToolsInvocations});
            }
            AiMessage aiMessage = chatResponse.aiMessage();
            if (chatMemory != null) {
                chatMemory.add((ChatMessage)aiMessage);
            } else {
                messages = new ArrayList<ChatMessage>(messages);
                messages.add((ChatMessage)aiMessage);
            }
            if (!aiMessage.hasToolExecutionRequests()) break;
            intermediateResponses.add(chatResponse);
            for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                ToolExecutor toolExecutor = toolExecutors.get(toolExecutionRequest.name());
                ToolExecutionResultMessage toolExecutionResultMessage = toolExecutor == null ? this.applyToolHallucinationStrategy(toolExecutionRequest) : ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)toolExecutor.execute(toolExecutionRequest, memoryId));
                toolExecutions.add(ToolExecution.builder().request(toolExecutionRequest).result(toolExecutionResultMessage.text()).build());
                if (chatMemory != null) {
                    chatMemory.add((ChatMessage)toolExecutionResultMessage);
                    continue;
                }
                messages.add(toolExecutionResultMessage);
            }
            if (chatMemory != null) {
                messages = chatMemory.messages();
            }
            ChatRequest chatRequest = ChatRequest.builder().messages(messages).parameters(parameters).build();
            chatResponse = chatModel.chat(chatRequest);
            aggregateTokenUsage = TokenUsage.sum((TokenUsage)aggregateTokenUsage, (TokenUsage)chatResponse.metadata().tokenUsage());
        }
        return ToolServiceResult.builder().intermediateResponses(intermediateResponses).finalResponse(chatResponse).toolExecutions(toolExecutions).aggregateTokenUsage(aggregateTokenUsage).build();
    }

    public ToolExecutionResultMessage applyToolHallucinationStrategy(ToolExecutionRequest toolExecutionRequest) {
        return this.toolHallucinationStrategy.apply(toolExecutionRequest);
    }

    public List<ToolSpecification> toolSpecifications() {
        return this.toolSpecifications;
    }

    public Map<String, ToolExecutor> toolExecutors() {
        return this.toolExecutors;
    }

    public ToolProvider toolProvider() {
        return this.toolProvider;
    }
}

