/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.document.parser;

import dev.langchain4j.data.document.BlankDocumentException;
import dev.langchain4j.data.document.Document;
import dev.langchain4j.data.document.DocumentParser;
import dev.langchain4j.internal.ValidationUtils;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class TextDocumentParser
implements DocumentParser {
    private final Charset charset;

    public TextDocumentParser() {
        this(StandardCharsets.UTF_8);
    }

    public TextDocumentParser(Charset charset) {
        this.charset = (Charset)ValidationUtils.ensureNotNull((Object)charset, (String)"charset");
    }

    public Document parse(InputStream inputStream) {
        try {
            String text = new String(inputStream.readAllBytes(), this.charset);
            if (text.isBlank()) {
                throw new BlankDocumentException();
            }
            return Document.from((String)text);
        }
        catch (BlankDocumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

