/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.components.progress;

import de.agilecoders.wicket.core.markup.html.bootstrap.components.progress.ProgressBar;
import de.agilecoders.wicket.core.markup.html.bootstrap.components.progress.UploadProgressBarJavaScriptReference;
import de.agilecoders.wicket.core.util.Attributes;
import java.io.Serializable;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.resource.ResourceReference;

public class UploadProgressBar
extends org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadProgressBar {
    private ProgressBar.Type type = ProgressBar.Type.DEFAULT;
    private boolean active = false;
    private boolean striped = false;

    public UploadProgressBar(String id, Form<?> form) {
        this(id, form, (IModel<Integer>)Model.of((Serializable)Integer.valueOf(0)));
    }

    public UploadProgressBar(String id, Form<?> form, IModel<Integer> model) {
        this(id, form, null, model);
    }

    public UploadProgressBar(String id, Form<?> form, FileUploadField fileUploadField, IModel<Integer> model) {
        super(id, form, fileUploadField);
        this.setRenderBodyOnly(false);
        this.setDefaultModel(model);
    }

    protected ResourceReference getCss() {
        return null;
    }

    public boolean striped() {
        return this.striped;
    }

    public UploadProgressBar striped(boolean value) {
        this.striped = value;
        return this;
    }

    public boolean active() {
        return this.active;
    }

    public UploadProgressBar active(boolean value) {
        this.active = value;
        if (value) {
            this.striped(true);
        }
        return this;
    }

    public ProgressBar.Type type() {
        return this.type;
    }

    public UploadProgressBar type(ProgressBar.Type type) {
        this.type = type;
        return this;
    }

    protected MarkupContainer newBarComponent(String id) {
        return new WebMarkupContainer(id){

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                if (!ProgressBar.Type.DEFAULT.equals(UploadProgressBar.this.type)) {
                    Attributes.addClass(tag, UploadProgressBar.this.type().cssClassName());
                }
                tag.put("style", (CharSequence)UploadProgressBar.this.createStyleValue().getObject());
            }
        };
    }

    protected MarkupContainer newStatusComponent(String id) {
        MarkupContainer status = super.newStatusComponent(id);
        status.setVisible(false);
        return status;
    }

    private IModel<String> createStyleValue() {
        return Model.of((Serializable)((Object)String.format("width: %s%%", this.value())));
    }

    public final boolean complete() {
        return this.value() == 100;
    }

    public UploadProgressBar value(IModel<Integer> value) {
        this.setDefaultModel(value);
        return this;
    }

    public UploadProgressBar value(Integer value) {
        this.setDefaultModelObject(value);
        return this;
    }

    public Integer value() {
        return Math.max(Math.min((Integer)this.getDefaultModelObject(), 100), 0);
    }

    protected void onComponentTag(ComponentTag tag) {
        super.onComponentTag(tag);
        ProgressBar.internalOnComponentTag(tag, this.active(), this.striped());
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new UploadProgressBarJavaScriptReference()));
    }
}

