/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.core.markup.html.bootstrap.behavior;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.markup.html.references.Html5ShivJavaScriptReference;
import de.agilecoders.wicket.core.markup.html.references.RespondJavaScriptReference;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.request.WebClientInfo;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Args;

public class BootstrapBaseBehavior
extends Behavior {
    private static final BootstrapBaseBehavior INSTANCE = new BootstrapBaseBehavior();

    public static BootstrapBaseBehavior instance() {
        return INSTANCE;
    }

    public static void removeFrom(Component component) {
        Args.notNull((Object)component, (String)"component");
        component.remove(new Behavior[]{INSTANCE});
    }

    public static void addTo(Component component) {
        Args.notNull((Object)component, (String)"component");
        component.add(new Behavior[]{INSTANCE});
    }

    protected final IBootstrapSettings getBootstrapSettings(Component component) {
        Args.notNull((Object)component, (String)"component");
        IBootstrapSettings settings = Bootstrap.getSettings(component.getApplication());
        if (settings == null) {
            throw new WicketRuntimeException("No BootstrapSettings associated with this Application. Did you call Bootstrap.install()?");
        }
        return settings;
    }

    public void renderHead(Component component, IHeaderResponse headerResponse) {
        IBootstrapSettings settings = this.getBootstrapSettings(component);
        this.renderHead(settings, headerResponse);
    }

    public void renderHead(IBootstrapSettings settings, IHeaderResponse headerResponse) {
        ITheme theme = settings.getActiveThemeProvider().getActiveTheme();
        theme.renderHead(headerResponse);
        this.contributeIE8Dependencies(headerResponse);
    }

    protected void contributeIE8Dependencies(IHeaderResponse headerResponse) {
        WebClientInfo clientInfo = WebSession.get().getClientInfo();
        ClientProperties properties = clientInfo.getProperties();
        if (properties.isBrowserInternetExplorer() && properties.getBrowserVersionMajor() < 9) {
            headerResponse.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)RespondJavaScriptReference.instance()));
            headerResponse.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)Html5ShivJavaScriptReference.instance()));
        }
    }
}

