/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang.math;

import java.io.Serializable;

public final class Fraction
extends Number
implements Serializable,
Comparable {
    private static final long serialVersionUID = 65382027393090L;
    public static final Fraction ZERO = new Fraction(0, 1);
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ONE_HALF = new Fraction(1, 2);
    public static final Fraction ONE_THIRD = new Fraction(1, 3);
    public static final Fraction TWO_THIRDS = new Fraction(2, 3);
    public static final Fraction ONE_QUARTER = new Fraction(1, 4);
    public static final Fraction TWO_QUARTERS = new Fraction(2, 4);
    public static final Fraction THREE_QUARTERS = new Fraction(3, 4);
    public static final Fraction ONE_FIFTH = new Fraction(1, 5);
    public static final Fraction TWO_FIFTHS = new Fraction(2, 5);
    public static final Fraction THREE_FIFTHS = new Fraction(3, 5);
    public static final Fraction FOUR_FIFTHS = new Fraction(4, 5);
    private final int numerator;
    private final int denominator;
    private transient int hashCode = 0;
    private transient String toString = null;
    private transient String toProperString = null;

    private Fraction(int numerator, int denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public static Fraction getFraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            numerator = -numerator;
            denominator = -denominator;
        }
        return new Fraction(numerator, denominator);
    }

    public static Fraction getFraction(int whole, int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            throw new ArithmeticException("The denominator must not be negative");
        }
        if (numerator < 0) {
            throw new ArithmeticException("The numerator must not be negative");
        }
        numerator = whole < 0 ? whole * denominator - numerator : whole * denominator + numerator;
        return new Fraction(numerator, denominator);
    }

    public static Fraction getReducedFraction(int numerator, int denominator) {
        int gcd;
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (denominator < 0) {
            numerator = -numerator;
            denominator = -denominator;
        }
        if ((gcd = Fraction.greatestCommonDenominator(Math.abs(numerator), denominator)) == 0) {
            return new Fraction(numerator, denominator);
        }
        return new Fraction(numerator / gcd, denominator / gcd);
    }

    public static Fraction getFraction(double value) {
        double delta1;
        if (Double.isInfinite(value) || Double.isNaN(value)) {
            throw new ArithmeticException("The value must not be infinite or NaN");
        }
        int sign = value < 0.0 ? -1 : 1;
        value = Math.abs(value);
        int wholeNumber = (int)value;
        value -= (double)wholeNumber;
        int numer0 = 0;
        int denom0 = 1;
        int numer1 = 1;
        int denom1 = 0;
        int numer2 = 0;
        int denom2 = 0;
        int a1 = (int)value;
        int a2 = 0;
        double x1 = 1.0;
        double x2 = 0.0;
        double y1 = value - (double)a1;
        double y2 = 0.0;
        double delta2 = Double.MAX_VALUE;
        int i = 1;
        do {
            delta1 = delta2;
            a2 = (int)(x1 / y1);
            x2 = y1;
            y2 = x1 - (double)a2 * y1;
            numer2 = a1 * numer1 + numer0;
            denom2 = a1 * denom1 + denom0;
            double fraction = (double)numer2 / (double)denom2;
            delta2 = Math.abs(value - fraction);
            a1 = a2;
            x1 = x2;
            y1 = y2;
            numer0 = numer1;
            denom0 = denom1;
            numer1 = numer2;
            denom1 = denom2;
        } while (delta1 > delta2 && denom2 <= 10000 && denom2 > 0 && ++i < 25);
        if (i == 25) {
            throw new ArithmeticException("Unable to convert double to fraction");
        }
        return Fraction.getReducedFraction((numer0 + wholeNumber * denom0) * sign, denom0);
    }

    public static Fraction getFraction(String str) {
        if (str == null) {
            throw new IllegalArgumentException("The string must not be null");
        }
        int pos = str.indexOf(46);
        if (pos >= 0) {
            return Fraction.getFraction(Double.parseDouble(str));
        }
        pos = str.indexOf(32);
        if (pos > 0) {
            int whole = Integer.parseInt(str.substring(0, pos));
            if ((pos = (str = str.substring(pos + 1)).indexOf(47)) < 0) {
                throw new NumberFormatException("The fraction could not be parsed as the format X Y/Z");
            }
            int denom = Integer.parseInt(str.substring(pos + 1));
            return Fraction.getFraction(Integer.parseInt(str.substring(0, pos)) + whole * denom, denom);
        }
        pos = str.indexOf(47);
        if (pos < 0) {
            return Fraction.getFraction(Integer.parseInt(str), 1);
        }
        return Fraction.getFraction(Integer.parseInt(str.substring(0, pos)), Integer.parseInt(str.substring(pos + 1)));
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getProperNumerator() {
        return Math.abs(this.numerator % this.denominator);
    }

    public int getProperWhole() {
        return this.numerator / this.denominator;
    }

    public int intValue() {
        return this.numerator / this.denominator;
    }

    public long longValue() {
        return (long)this.numerator / (long)this.denominator;
    }

    public float floatValue() {
        return (float)this.numerator / (float)this.denominator;
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public Fraction reduce() {
        int gcd = Fraction.greatestCommonDenominator(Math.abs(this.numerator), this.denominator);
        if (gcd == 0) {
            return this;
        }
        return Fraction.getFraction(this.numerator / gcd, this.denominator / gcd);
    }

    public Fraction invert() {
        if (this.numerator == 0) {
            throw new ArithmeticException("Unable to invert a fraction with a zero numerator");
        }
        return Fraction.getFraction(this.denominator, this.numerator);
    }

    public Fraction negate() {
        return Fraction.getFraction(-this.numerator, this.denominator);
    }

    public Fraction abs() {
        if (this.numerator >= 0) {
            return this;
        }
        return Fraction.getFraction(-this.numerator, this.denominator);
    }

    public Fraction pow(int power) {
        if (power == 1) {
            return this;
        }
        if (power == 0) {
            return ONE;
        }
        if (power < 0) {
            return Fraction.getFraction((int)Math.pow(this.denominator, -power), (int)Math.pow(this.numerator, -power));
        }
        return Fraction.getFraction((int)Math.pow(this.numerator, power), (int)Math.pow(this.denominator, power));
    }

    private static int greatestCommonDenominator(int number1, int number2) {
        int remainder = number1 % number2;
        while (remainder != 0) {
            number1 = number2;
            number2 = remainder;
            remainder = number1 % number2;
        }
        return number2;
    }

    public Fraction add(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0) {
            return fraction;
        }
        if (fraction.numerator == 0) {
            return this;
        }
        if (this.denominator == fraction.denominator) {
            return Fraction.getReducedFraction(this.numerator + fraction.numerator, this.denominator);
        }
        return Fraction.getReducedFraction(this.numerator * fraction.denominator + this.denominator * fraction.numerator, this.denominator * fraction.denominator);
    }

    public Fraction subtract(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0) {
            return fraction.negate();
        }
        if (fraction.numerator == 0) {
            return this;
        }
        if (this.denominator == fraction.denominator) {
            return Fraction.getReducedFraction(this.numerator - fraction.numerator, this.denominator);
        }
        return Fraction.getReducedFraction(this.numerator * fraction.denominator - this.denominator * fraction.numerator, this.denominator * fraction.denominator);
    }

    public Fraction multiplyBy(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        return Fraction.getReducedFraction(this.numerator * fraction.numerator, this.denominator * fraction.denominator);
    }

    public Fraction divideBy(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (fraction.numerator == 0) {
            throw new ArithmeticException("The fraction to divide by must not be zero");
        }
        if (this.numerator == 0) {
            return ZERO;
        }
        return Fraction.getReducedFraction(this.numerator * fraction.denominator, this.denominator * fraction.numerator);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Fraction)) {
            return false;
        }
        Fraction other = (Fraction)obj;
        return this.numerator == other.numerator && this.denominator == other.denominator;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 17;
            this.hashCode = 37 * this.hashCode + this.numerator;
            this.hashCode = 37 * this.hashCode + this.denominator;
        }
        return this.hashCode;
    }

    public int compareTo(Object object) {
        Fraction other = (Fraction)object;
        if (this.numerator == other.numerator && this.denominator == other.denominator) {
            return 0;
        }
        long first = (long)this.numerator * (long)other.denominator;
        long second = (long)other.numerator * (long)this.denominator;
        if (first == second) {
            return 0;
        }
        if (first < second) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = new StringBuffer(32).append(this.numerator).append('/').append(this.denominator).toString();
        }
        return this.toString;
    }

    public String toProperString() {
        if (this.toProperString == null) {
            int properNumerator;
            this.toProperString = this.numerator == 0 ? "0" : (this.numerator == this.denominator ? "1" : (Math.abs(this.numerator) > this.denominator ? ((properNumerator = this.getProperNumerator()) == 0 ? Integer.toString(this.getProperWhole()) : new StringBuffer(32).append(this.getProperWhole()).append(' ').append(properNumerator).append('/').append(this.denominator).toString()) : new StringBuffer(32).append(this.numerator).append('/').append(this.denominator).toString()));
        }
        return this.toProperString;
    }
}

