/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.google.gson.reflect.TypeToken;
import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.api.YunpianApi;
import com.yunpian.sdk.api.YunpianApiResult;
import com.yunpian.sdk.model.Blackword;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.model.SmsBatchSend;
import com.yunpian.sdk.model.SmsRecord;
import com.yunpian.sdk.model.SmsReply;
import com.yunpian.sdk.model.SmsSingleSend;
import com.yunpian.sdk.model.SmsStatus;
import com.yunpian.sdk.util.JsonUtil;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;

public class SmsApi
extends YunpianApi {
    public static final String NAME = "sms";
    private static final Type TypeListReply = new TypeToken<List<SmsReply>>(){}.getType();
    private static final Type TypeListRecord = new TypeToken<List<SmsRecord>>(){}.getType();
    private static final Type TypeListStatus = new TypeToken<List<SmsStatus>>(){}.getType();
    private static final Type TypeListBatch = new TypeToken<List<SmsSingleSend>>(){}.getType();

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(YunpianClient clnt) {
        super.init(clnt);
        this.host(clnt.getConf().getConf("yp.sms.host", "https://sms.yunpian.com"));
    }

    @Deprecated
    public Result<SmsSingleSend> send(Map<String, String> param) {
        Result<SmsSingleSend> r = new Result<SmsSingleSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "text");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<SmsSingleSend> h = new YunpianApiResult.MapResultHandler<SmsSingleSend>(){

            @Override
            public SmsSingleSend data(Map<String, String> rsp) {
                switch (SmsApi.this.version()) {
                    case "v1": {
                        return JsonUtil.fromJson(rsp.get("result"), SmsSingleSend.class);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SmsApi.this.version());
            }
        };
        try {
            return this.path("send.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<SmsSingleSend> single_send(Map<String, String> param) {
        Result<SmsSingleSend> r = new Result<SmsSingleSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "text");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<SmsSingleSend> h = new YunpianApiResult.MapResultHandler<SmsSingleSend>(){

            @Override
            public SmsSingleSend data(Map<String, String> rsp) {
                switch (SmsApi.this.version()) {
                    case "v2": {
                        return SmsApi.this.map2SendSingleSmsInfo(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SmsApi.this.version());
            }
        };
        try {
            return this.path("single_send.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<SmsBatchSend> batch_send(Map<String, String> param) {
        Result<SmsBatchSend> r = new Result<SmsBatchSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "text");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<SmsBatchSend> h = new YunpianApiResult.MapResultHandler<SmsBatchSend>(){

            @Override
            public SmsBatchSend data(Map<String, String> rsp) {
                switch (SmsApi.this.version()) {
                    case "v2": {
                        return SmsApi.this.map2SendBatchSmsInfo(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SmsApi.this.version());
            }
        };
        try {
            return this.path("batch_send.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<SmsBatchSend> multi_send(Map<String, String> param) {
        Result<SmsBatchSend> r = new Result<SmsBatchSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "text");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<SmsBatchSend> h = new YunpianApiResult.MapResultHandler<SmsBatchSend>(){

            @Override
            public SmsBatchSend data(Map<String, String> rsp) {
                switch (SmsApi.this.version()) {
                    case "v2": {
                        return SmsApi.this.map2SendBatchSmsInfo(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SmsApi.this.version());
            }
        };
        try {
            return this.path("multi_send.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<Result<SmsSingleSend>>> multi_send_v1(Map<String, String> param) {
        Result<List<Result<SmsSingleSend>>> r = new Result<List<Result<SmsSingleSend>>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "text");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<Result<SmsSingleSend>> h = new YunpianApiResult.SimpleListResultHandler<Result<SmsSingleSend>>(){

            @Override
            public List<Result<SmsSingleSend>> data(List<Result<SmsSingleSend>> rsp) {
                switch (SmsApi.this.version()) {
                    case "v1": {
                        return rsp;
                    }
                }
                return null;
            }

            @Override
            public Integer code(List<Result<SmsSingleSend>> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, SmsApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<SmsSingleSend>>(){}.getType();
            }
        };
        try {
            return this.version("v1").path("multi_send.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<SmsStatus>> pull_status(Map<String, String> param) {
        Result<List<SmsStatus>> r = new Result<List<SmsStatus>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<SmsStatus> h = new YunpianApiResult.SimpleListResultHandler<SmsStatus>(){

            @Override
            public List<SmsStatus> data(List<SmsStatus> rsp) {
                switch (SmsApi.this.version()) {
                    case "v1": {
                        if (this.rspMap != null) {
                            String flow = (String)this.rspMap.get("sms_status");
                            return (List)JsonUtil.fromJson(flow, TypeListStatus);
                        }
                    }
                    case "v2": {
                        return rsp;
                    }
                }
                return Collections.emptyList();
            }

            @Override
            public Integer code(List<SmsStatus> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, SmsApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<SmsStatus>>(){}.getType();
            }
        };
        try {
            return this.path("pull_status.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<SmsReply>> pull_reply(Map<String, String> param) {
        Result<List<SmsReply>> r = new Result<List<SmsReply>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<SmsReply> h = new YunpianApiResult.SimpleListResultHandler<SmsReply>(){

            @Override
            public List<SmsReply> data(List<SmsReply> rsp) {
                switch (SmsApi.this.version()) {
                    case "v1": {
                        String smsReply;
                        if (this.rspMap != null && (smsReply = (String)this.rspMap.get("sms_reply")) != null && smsReply.startsWith("[")) {
                            return (List)JsonUtil.fromJson(smsReply, TypeListReply);
                        }
                    }
                    case "v2": {
                        return rsp;
                    }
                }
                return null;
            }

            @Override
            public Integer code(List<SmsReply> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, SmsApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<SmsReply>>(){}.getType();
            }
        };
        try {
            return this.path("pull_reply.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<SmsReply>> get_reply(Map<String, String> param) {
        Result<List<SmsReply>> r = new Result<List<SmsReply>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "start_time", "end_time", "page_num", "page_size");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<SmsReply> h = new YunpianApiResult.SimpleListResultHandler<SmsReply>(){

            @Override
            public List<SmsReply> data(List<SmsReply> rsp) {
                switch (SmsApi.this.version()) {
                    case "v1": {
                        String smsReply;
                        if (this.rspMap != null && (smsReply = (String)this.rspMap.get("sms_reply")) != null && smsReply.startsWith("[")) {
                            return (List)JsonUtil.fromJson(smsReply, TypeListReply);
                        }
                    }
                    case "v2": {
                        return rsp;
                    }
                }
                return null;
            }

            @Override
            public Integer code(List<SmsReply> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, SmsApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<SmsReply>>(){}.getType();
            }
        };
        try {
            return this.path("get_reply.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<String>> get_black_word(Map<String, String> param) {
        Result<List<String>> r = new Result<List<String>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "text");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<String> h = new YunpianApiResult.SimpleListResultHandler<String>(){

            @Override
            public List<String> data(List<String> rsp) {
                switch (SmsApi.this.version()) {
                    case "v1": {
                        String result;
                        if (this.rspMap != null && (result = (String)this.rspMap.get("result")) != null) {
                            return JsonUtil.fromJson(result, Blackword.class).toList();
                        }
                    }
                    case "v2": {
                        return rsp;
                    }
                }
                return null;
            }

            @Override
            public Integer code(List<String> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, SmsApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return new TypeToken<List<String>>(){}.getType();
            }
        };
        try {
            return this.path("get_black_word.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<List<SmsRecord>> get_record(Map<String, String> param) {
        Result<List<SmsRecord>> r = new Result<List<SmsRecord>>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "start_time", "end_time");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.SimpleListResultHandler<SmsRecord> h = new YunpianApiResult.SimpleListResultHandler<SmsRecord>(){

            @Override
            public List<SmsRecord> data(List<SmsRecord> rsp) {
                switch (SmsApi.this.version()) {
                    case "v1": {
                        String sms;
                        if (this.rspMap != null && (sms = (String)this.rspMap.get(SmsApi.NAME)) != null && sms.startsWith("[")) {
                            return (List)JsonUtil.fromJson(sms, TypeListRecord);
                        }
                    }
                    case "v2": {
                        return rsp;
                    }
                }
                return null;
            }

            @Override
            public Integer code(List<SmsRecord> rsp) {
                if (this.rspMap != null) {
                    return YunpianApi.code(this.rspMap, SmsApi.this.version());
                }
                return 0;
            }

            @Override
            Type rspType() {
                return TypeListRecord;
            }
        };
        try {
            return this.path("get_record.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Integer> count(Map<String, String> param) {
        Result<Integer> r = new Result<Integer>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "start_time", "end_time");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Integer> h = new YunpianApiResult.MapResultHandler<Integer>(){

            @Override
            public Integer data(Map<String, String> rsp) {
                try {
                    return Integer.parseInt(rsp.get("total"));
                }
                catch (Exception exception) {
                    return 0;
                }
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SmsApi.this.version());
            }
        };
        try {
            return this.path("count.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    @Deprecated
    public Result<SmsSingleSend> tpl_send(Map<String, String> param) {
        Result<SmsSingleSend> r = new Result<SmsSingleSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "tpl_id", "tpl_value");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<SmsSingleSend> h = new YunpianApiResult.MapResultHandler<SmsSingleSend>(){

            @Override
            public SmsSingleSend data(Map<String, String> rsp) {
                switch (SmsApi.this.version()) {
                    case "v1": {
                        String result = rsp.get("result");
                        if (result == null || !result.startsWith("{")) break;
                        return JsonUtil.fromJson(result, SmsSingleSend.class);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SmsApi.this.version());
            }
        };
        try {
            return this.path("tpl_send.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    @Deprecated
    public Result<SmsSingleSend> tpl_single_send(Map<String, String> param) {
        Result<SmsSingleSend> r = new Result<SmsSingleSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "tpl_id", "tpl_value");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<SmsSingleSend> h = new YunpianApiResult.MapResultHandler<SmsSingleSend>(){

            @Override
            public SmsSingleSend data(Map<String, String> rsp) {
                switch (SmsApi.this.version()) {
                    case "v2": {
                        return SmsApi.this.map2SendSingleSmsInfo(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SmsApi.this.version());
            }
        };
        try {
            return this.path("tpl_single_send.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    @Deprecated
    public Result<SmsBatchSend> tpl_batch_send(Map<String, String> param) {
        Result<SmsBatchSend> r = new Result<SmsBatchSend>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile", "tpl_id", "tpl_value");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<SmsBatchSend> h = new YunpianApiResult.MapResultHandler<SmsBatchSend>(){

            @Override
            public SmsBatchSend data(Map<String, String> rsp) {
                switch (SmsApi.this.version()) {
                    case "v2": {
                        return SmsApi.this.map2SendBatchSmsInfo(rsp);
                    }
                }
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SmsApi.this.version());
            }
        };
        try {
            return this.path("tpl_batch_send.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    public Result<Void> reg_complete(Map<String, String> param) {
        Result<Void> r = new Result<Void>();
        List<NameValuePair> list = this.param2pair(param, r, "apikey", "mobile");
        if (r.getCode() != 0) {
            return r;
        }
        String data = this.urlEncode(list);
        YunpianApiResult.MapResultHandler<Void> h = new YunpianApiResult.MapResultHandler<Void>(){

            @Override
            public Void data(Map<String, String> rsp) {
                return null;
            }

            @Override
            public Integer code(Map<String, String> rsp) {
                return YunpianApi.code(rsp, SmsApi.this.version());
            }
        };
        try {
            return this.path("reg_complete.json").post(data, h, r);
        }
        catch (Exception e) {
            return h.catchExceptoin(e, r);
        }
    }

    protected SmsBatchSend map2SendBatchSmsInfo(Map<String, String> rsp) {
        if (rsp != null) {
            try {
                SmsBatchSend info = new SmsBatchSend();
                info.setTotal_count(Integer.parseInt(rsp.get("total_count")));
                info.setTotal_fee(Double.parseDouble(rsp.get("total_fee")));
                info.setUnit(rsp.get("unit"));
                String data = rsp.get("data");
                if (data != null && data.startsWith("[")) {
                    info.setData((List)JsonUtil.fromJson(data, TypeListBatch));
                }
                return info;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e.fillInStackTrace());
            }
        }
        return null;
    }

    protected SmsSingleSend map2SendSingleSmsInfo(Map<String, String> rsp) {
        if (rsp != null) {
            try {
                SmsSingleSend info = new SmsSingleSend();
                if (rsp.containsKey("code")) {
                    info.setCode(Integer.parseInt(rsp.get("code")));
                }
                if (rsp.containsKey("msg")) {
                    info.setMsg(rsp.get("msg"));
                }
                if (rsp.containsKey("mobile")) {
                    info.setMobile(rsp.get("mobile"));
                }
                if (rsp.containsKey("unit")) {
                    info.setUnit(rsp.get("unit"));
                }
                info.setCount(Integer.parseInt(rsp.get("count")));
                info.setFee(Double.parseDouble(rsp.get("fee")));
                info.setSid(Long.parseLong(rsp.get("sid")));
                return info;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), e.fillInStackTrace());
            }
        }
        return null;
    }
}

