/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk;

import com.yunpian.sdk.YunpianConf;
import com.yunpian.sdk.api.ApiFactory;
import com.yunpian.sdk.api.CallApi;
import com.yunpian.sdk.api.FlowApi;
import com.yunpian.sdk.api.ShortUrlApi;
import com.yunpian.sdk.api.SignApi;
import com.yunpian.sdk.api.SmsApi;
import com.yunpian.sdk.api.TplApi;
import com.yunpian.sdk.api.UserApi;
import com.yunpian.sdk.api.VoiceApi;
import com.yunpian.sdk.constant.YunpianConstant;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClients;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunpianClient
implements YunpianConstant {
    static final Logger LOG = LoggerFactory.getLogger(YunpianClient.class);
    private CloseableHttpAsyncClient clnt;
    private YunpianConf conf = new YunpianConf();
    private ApiFactory api;
    private static ContentType DefaultContentType;
    static Map<String, String> HEADERS;

    public YunpianClient() {
        this(System.getProperty("yp.apikey"), System.getProperty("yp.file"));
    }

    public YunpianClient(String apikey) {
        this(apikey, System.getProperty("yp.file"));
    }

    public YunpianClient(String apikey, String file) {
        this.conf.with(apikey);
        if (file != null) {
            this.conf.with(new File(System.getProperty("yp.file", file)));
        }
    }

    public YunpianClient(String apikey, InputStream in) {
        this.conf.with(apikey).with(in);
    }

    public YunpianClient(String apikey, Properties props) {
        this.conf.with(apikey).with(props);
    }

    public UserApi user() {
        return (UserApi)this.api.api("user");
    }

    public CallApi call() {
        return (CallApi)this.api.api("call");
    }

    public FlowApi flow() {
        return (FlowApi)this.api.api("flow");
    }

    public SignApi sign() {
        return (SignApi)this.api.api("sign");
    }

    public SmsApi sms() {
        return (SmsApi)this.api.api("sms");
    }

    public TplApi tpl() {
        return (TplApi)this.api.api("tpl");
    }

    public VoiceApi voice() {
        return (VoiceApi)this.api.api("voice");
    }

    public ShortUrlApi shortUrl() {
        return (ShortUrlApi)this.api.api("short_url");
    }

    @PostConstruct
    public YunpianClient init() {
        LOG.info("YunpianClient is initing!");
        try {
            if (this.clnt != null) {
                this.close();
            }
            this.clnt = this.createHttpAsyncClient(this.conf.build());
            DefaultContentType = ContentType.create((String)"application/x-www-form-urlencoded", (Charset)Charset.forName(this.conf.getConf("http.charset", "utf-8")));
            this.api = new ApiFactory(this);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), e.fillInStackTrace());
        }
        return this;
    }

    public YunpianConf getConf() {
        return this.conf;
    }

    private CloseableHttpAsyncClient createHttpAsyncClient(YunpianConf conf) throws IOReactorException {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setIoThreadCount(Runtime.getRuntime().availableProcessors()).setConnectTimeout(conf.getConfInt("http.conn.timeout", "10000")).setSoTimeout(conf.getConfInt("http.so.timeout", "30000")).build();
        DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
        PoolingNHttpClientConnectionManager connManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(Charset.forName(conf.getConf("http.charset", "utf-8"))).build();
        connManager.setDefaultConnectionConfig(connectionConfig);
        connManager.setMaxTotal(conf.getConfInt("http.conn.maxtotal", "100"));
        connManager.setDefaultMaxPerRoute(conf.getConfInt("http.conn.maxperroute", "10"));
        CloseableHttpAsyncClient httpclient = HttpAsyncClients.custom().setConnectionManager((NHttpClientConnectionManager)connManager).build();
        httpclient.start();
        return httpclient;
    }

    public final Map<String, String> newParam(int size) {
        return size <= 0 ? Collections.emptyMap() : new HashMap(size + 1, 1.0f);
    }

    public Future<HttpResponse> post(String uri, String data) {
        return this.post(uri, data, DefaultContentType.getMimeType(), DefaultContentType.getCharset(), HEADERS);
    }

    public void closeResponse(HttpResponse rsp) {
        EntityUtils.consumeQuietly((HttpEntity)rsp.getEntity());
    }

    public Future<HttpResponse> post(String uri, String data, String mimeType, Charset charset, Map<String, String> headers) {
        HttpPost req = new HttpPost(uri);
        req.setEntity((HttpEntity)new StringEntity(data, ContentType.create((String)(mimeType == null ? DefaultContentType.getMimeType() : mimeType), (Charset)(charset == null ? DefaultContentType.getCharset() : charset))));
        if (headers == null) {
            headers = HEADERS;
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            req.setHeader(e.getKey(), e.getValue());
        }
        return this.clnt.execute((HttpUriRequest)req, null);
    }

    public HttpAsyncClient http() {
        return this.clnt;
    }

    @PreDestroy
    public void close() {
        LOG.info("YunpianClient is closing!");
        if (this.clnt != null) {
            try {
                this.clnt.close();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        return this.conf.toString();
    }

    static {
        HEADERS = new HashMap<String, String>(1, 1.0f);
        HEADERS.put("Api-Lang", "java");
    }
}

